/* =================================================================================================================================
*
* UPGRADE TO DEMOTIC 1.1
* DIFFICULTY: INTERMEDIATE DB ADMIN
*
===================================================================================================================================*/

/*
* INSTUCTION 1
* INSTALL USERS PLUGIN
* IF YOUR STORAGE TABLE IS NOT `dm_plugin` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `dm_plugin` (`title`, `name`, `version`, `isActive`) VALUES
('Users', 'Users', '1.00', 1);

/*
* INSTUCTION 2
* SET USERS PLUGIN OPTIONS
* IF YOUR STORAGE TABLE IS NOT `dm_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `dm_storage` (`plugin`, `key`, `value`) VALUES
('Config', 'Users.allowRegistrations', '\"No\"');

/*
* INSTUCTION 3
* ADD USERS TABLE
* IF YOUR PREFIX IS NOT `dm_` REPLACE WITH THE APPROPRIATE PREFIX HERE FOR 'dm_user'
*/
CREATE TABLE `dm_user` (
  `id` int(11) NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `resetSecret` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resetTime` int(11) DEFAULT NULL,
  `createdAt` timestamp NOT NULL DEFAULT current_timestamp(),
  `lastActiveAt` timestamp NULL DEFAULT NULL,
  `isDeleted` int(1) NOT NULL DEFAULT 0,
  `deletedAt` timestamp NULL DEFAULT NULL,
  `isVerified` int(1) NOT NULL DEFAULT 0,
  `verifiedAt` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `dm_user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `username` (`username`),
  ADD KEY `email` (`email`);

/*
* INSTUCTION 4
* UPDATE THE CACHE NUMBER
* IF YOUR STORAGE TABLE IS NOT `dm_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
UPDATE `dm_storage` SET `value` = '3' WHERE `dm_storage`.`plugin` = 'Demotic' AND `dm_storage`.`key` = 'cacheVersion';

/*
* INSTUCTION 5
* UPDATE THE VERSION NUMBER
* IF YOUR STORAGE TABLE IS NOT `dm_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
UPDATE `dm_storage` SET `value` = '\"1.1\"' WHERE `dm_storage`.`plugin` = 'Demotic' AND `dm_storage`.`key` = 'version';