/* =================================================================================================================================
*
* IF YOU ARE MOVING YOUR IMPRESSPAGES TO DEMOTIC CMS THIS SQL FILE HAS THE MySQL COMMANDS TO DO JUST THAT
* FOLLOW THESE INSTRUCTIONS CAREFULLY
* NOTE: BACKUP YOUR ENTIRE IMPRESSPAGES DATABASE BEFORE RUNNING THESE STATEMENTS
* DIFFICULTY: INTERMEDIATE DB ADMIN
*
===================================================================================================================================*/


/*
* INSTUCTION 1:
* TO CHANGE YOUR IMPRESSPAGES DATABASE FROM utf8_unicode_ci TO utf8mb4_unicode_ci
* REPLACE THE database_name WITH YOUR database's name e.g. ALTER DATABASE `cats_db` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
*/


ALTER DATABASE database_name CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;


/*
* INSTUCTION 2
* TO CHANGE YOUR IMPRESSPAGES DATABASE TABLES FROM utf8_unicode_ci TO utf8mb4_unicode_ci
* REPLACE THE table_name WITH YOUR database's name e.g. ALTER TABLE `ip_page` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
* DO THIS FOR EACH TABLE IN YOUR DATABASE
*/
ALTER TABLE table_name CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;


/*
* INSTUCTION 3
* ADDS TO YOUR IMPRESSPAGES PAGES TABLES THE post/page pageType COLUMN
* IF YOUR PAGES TABLE IS NOT `ip_page` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
ALTER TABLE `ip_page` ADD `pageType` ENUM('page', 'post') NOT NULL DEFAULT 'page' COMMENT 'The page type';

/*
* INSTUCTION 4
* UPDATE THE CACHE NUMBER
* IF YOUR STORAGE TABLE IS NOT `ip_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
UPDATE `ip_storage` SET `value` = '2' WHERE `ip_storage`.`plugin` = 'Ip' AND `ip_storage`.`key` = 'cacheVersion';

/*
* INSTUCTION 5
* UPDATE THE VERSION NUMBER
* IF YOUR STORAGE TABLE IS NOT `ip_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
UPDATE `ip_storage` SET `value` = '\"1.0\"' WHERE `ip_storage`.`plugin` = 'Ip' AND `ip_storage`.`key` = 'version';

/*
* INSTUCTION 6
* INSTALL BLOG PLUGIN
* IF YOUR STORAGE TABLE IS NOT `ip_plugin` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `ip_plugin` (`title`, `name`, `version`, `isActive`) VALUES
('Blog', 'Blog', '1.00', 1);

/*
* INSTUCTION 7
* SET BLOG PLUGIN OPTIONS
* IF YOUR STORAGE TABLE IS NOT `ip_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `ip_storage` (`plugin`, `key`, `value`) VALUES
('Config', 'Blog.addTitlelink', '\"Yes\"'),
('Config', 'Blog.allowedTags', '\"<b><span><i><strong><em><a><img><p><blockquote><s><u><sup><sub><strong>\"'),
('Config', 'Blog.blockName', '\"main\"'),
('Config', 'Blog.dateFormat', '\"Y-m-d\"'),
('Config', 'Blog.imageHeight', '\"0\"'),
('Config', 'Blog.imageWidth', '\"0\"'),
('Config', 'Blog.introLimit', '\"300\"'),
('Config', 'Blog.postLimit', '\"10\"'),
('Config', 'Blog.showDate', '\"No\"'),
('Config', 'Blog.showReadMore', '\"Yes\"'),
('Config', 'Blog.showTime', '\"No\"'),
('Config', 'Blog.timeFormat', '\"H:i:s\"');

/*
* INSTUCTION 8
* INSTALL SITEMAP XML PLUGIN
* IF YOUR STORAGE TABLE IS NOT `ip_plugin` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `ip_plugin` (`title`, `name`, `version`, `isActive`) VALUES
('Sitemap XML', 'SitemapXml', '1.00', 1);


/*
* INSTUCTION 9
* SET SITEMAP XML URL
* IF YOUR STORAGE TABLE IS NOT `ip_storage` REPLACE WITH THE APPROPRIATE TABLE NAME
*/
INSERT INTO `ip_storage` (`plugin`, `key`, `value`) VALUES
('Config', 'SitemapXml.sitemapUrl', '\"sitemap.xml\"');