<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
 
namespace Plugin\Users;

class AdminController extends \Demotic\GridController
{

    protected function config()
    {

        $gridConfig = array(
            'title' => __('Users', 'User', false),
            'table' => 'user',
            'sortField' => 'id',
            'createPosition' => 'top',
            'allowCreate' => false,
            'allowSort' => false,
            'fields' => array(
                array(
                    'label' => '',
                    'field' => 'id',
                    'preview' => function ($value, $recordData)
                        {
                            $manageUrl = ipRouteUrl('User_loginAsUser', array('userId'=> $recordData['id']));
                            return '<a target="_blank" class="btn btn-default" href="' . $manageUrl . '" >' . __('Login', 'User') . '</a>';
                        },
                    'allowSearch' => false
                ),
                array(
                    'label' => __('Id', 'User', false),
                    'field' => 'id',
                    'allowSearch' => true,
                    'allowUpdate' => false
                ),
                array(
                    'label' => __('User name', 'User', false),
                    'field' => 'username',
                    'transformations' => array('NullIfEmpty')
                ),
                array(
                    'label' => __('Email', 'User', false),
                    'field' => 'email',
                    'attributes' => array('autocomplete' => 'off'),
                ),
                array(
                    'label' => __('Password', 'User', false),
                    'field' => 'hash',
                    'type' => 'Password',
                    'attributes' => array('autocomplete' => 'off'),
                    'preview' => false
                )
            ),
            'beforeDelete' => array('Plugin\Users\GridHelper', 'beforeDelete'),
            'beforeUpdate' => array('Plugin\Users\GridHelper', 'beforeUpdate'),
            'updateFilter' => array('Plugin\Users\GridHelper', 'updateFilter')
        );

        $gridConfig = ipFilter('User_adminGridConfig', $gridConfig);
        return $gridConfig;
    }


    public function loginAsUser($userId)
    {
        if (ipUser()->loggedIn()) {
            ipUser()->logout();
        }
        ipUser()->login($userId);
        return new \Demotic\Response\Redirect(ipConfig()->baseUrl());
    }


}
