<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

namespace Demotic\Form\Field;

use Demotic\Form\Field;


class Captcha extends Field
{

    private $captchaInit;

    /**
     * Constructor
     *
     * @param array $options
     */
    public function __construct($options = array())
    {
        parent::__construct($options);
    }

    /**
     * Render field
     *
     * @param string $doctype
     * @param $environment
     * @return string
     */
    public function render($doctype, $environment)
    {
        $siteKey = ipGetOption('GoogleReCaptcha.siteKey');

        //hidden input field is required for javascript to properly mark errored field.
        return '
        <input ' . $this->getAttributesStr($doctype) . ' class="' . implode(
            ' ',
            $this->getClasses()
        ) . '" name="' . htmlspecialchars($this->getName()) . '" ' . $this->getValidationAttributesStr(
            $doctype
        ) . ' type="hidden" value="1" />
        <div class="form-group g-recaptcha" data-sitekey="' . $siteKey . '"></div>
        ';
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return self::TYPE_SYSTEM;
    }

    /**
     * Validate input value
     *
     * @param $values
     * @param $valueKey
     * @param $environment
     * @return string
     */
    public function validate($values, $valueKey, $environment)
    {
        if (ipGetOption('GoogleReCaptcha.mode') == 'Development') {
           return false;
        }

        $secret = ipGetOption('GoogleReCaptcha.secretKey');
        $recaptcha = new \ReCaptcha\ReCaptcha($secret);
        $resp = $recaptcha->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);

        if ($resp->isSuccess()) {
            return false;
        } else {
            $errorText = __('Sorry, we think you are a robot.', 'Demotic', false);
            return $errorText;
        }
    }


}
