<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Response;

/**
 *
 * Event dispatcher class
 *
 */
class PageNotFound extends \Demotic\Response\Layout
{

    public function __construct($content = null, $headers = null, $statusCode = 404)
    {
        if ($content === null) {
            $content = $this->generateError404Content();
        }
        parent::__construct($content, $headers, $statusCode);
        $this->addHeader('HTTP/1.0 404 Not Found');
        $this->setTitle(__('Error 404', 'Demotic', false));

    }

    public function getLayout()
    {
        if ($this->layout) {
            return $this->layout;
        }
        return is_file(ipThemeFile('404.php')) ? '404.php' : 'main.php';
    }

    protected function generateError404Content()
    {
        $data = array(
            'title' => __('Error 404', 'Demotic', false),
            'text' => self::error404Message()
        );
        $content = ipView(ipFile('Demotic/Gebtu/Config/view/error404.php'), $data)->render();
        return $content;
    }

    /**
     * Find the reason why the user come to non-existent URL
     * @return string error message
     */
    protected function error404Message()
    {
        $message = '';
        if (!isset($_SERVER['HTTP_REFERER']) || $_SERVER['HTTP_REFERER'] == '') {
            //mistyped URL
            $message = __('Sorry, but the page you were trying to get to does not exist.', 'Demotic', false);
        } else {
            if (strpos($_SERVER['HTTP_REFERER'], ipConfig()->baseUrl()) < 5 && strpos(
                    $_SERVER['HTTP_REFERER'],
                    ipConfig()->baseUrl()
                ) !== false
            ) {
                //Broken internal link
                $message = '<p>' . __('Sorry, but the page you were trying to get to does not exist.', 'Demotic') . '</p>';
            } elseif (strpos($_SERVER['HTTP_REFERER'], ipConfig()->baseUrl()) === false) {
                //Broken external link
                $message = '<p>' . __('Sorry, but the page you were trying to get to does not exist.', 'Demotic') . '</p>';
            }
        }
        return $message;
    }


}


