<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Response;


class JsonRpc extends Json
{
    public function __construct($result = null, $errorMessage = null, $errorCode = null, $id = null)
    {
        $data = array();

        if ($errorCode === null && $errorMessage === null) {
            $data['result'] = $result;
        } else { // Error
            if ($result !== null) {
                throw new \Demotic\Exception('JSON 2.0 response should not contain result and error info at the same time');
            }
            $data['error']['code'] = $errorCode !== null ? $errorCode : 1;
            $data['error']['message'] = $errorMessage;
        }

        $data['id'] = $id;

        parent::__construct($data);
    }

    public static function error($message, $code = 1, $id = null)
    {
        return new self(null, $message, $code, $id);
    }

    public static function result($data, $id = null)
    {
        return new self($data, null, null, $id);
    }

    public function isError()
    {
        return !empty($this->content['error']);
    }

    public function getError()
    {
        return array_key_exists('error', $this->content) ? $this->content['error'] : null;
    }

    public function addErrorData($key, $value)
    {
        $this->content['error'][$key] = $value;

        return $this;
    }

    public function getResult()
    {
        return array_key_exists('result', $this->content) ? $this->content['result'] : null;
    }
}