<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu;

/**
 * Value storage saves any php value.
 */
abstract class ValueStorage extends RawStorage
{
    /**
     * Get a value from storage
     *
     * @param string $key Key name
     * @param null $defaultValue Returned if specified key has no value assigned
     * @return string
     */
    public function get($key, $defaultValue = null)
    {
        $value = ipDb()->selectValue(
            $this->tableName,
            array($this->valueColumn),
            array($this->namespaceColumn => $this->namespace, $this->keyColumn => $key)
        );
        return ($value === null) ? $defaultValue : json_decode($value, true);
    }

    /**
     * Set storage value
     *
     * @param string $key Key name
     * @param mixed $value Value
     */
    public function set($key, $value)
    {
        parent::set($key, json_encode($value));
    }

    /**
     * Get all storage values
     *
     * @return array Key=>value array of all storage values
     */
    public function getAll()
    {
        $values = ipDb()->selectAll(
            $this->tableName,
            array($this->keyColumn, $this->valueColumn),
            array($this->namespaceColumn => $this->namespace)
        );

        $result = [];
        foreach ($values as $value) {
            $result[$value[$this->keyColumn]] = json_decode($value[$this->valueColumn], true);
        }
        return $result;
    }
}
