<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


namespace Demotic\Gebtu\Update;


class UpdateModel
{


    public function prepareForUpdate()
    {
        new \Demotic\Gebtu\Update\UpdateException(''); //autoload Update exception; As all core files will be deleted soon.
        new \Demotic\Response\Json([]); //autoload Json; As all core files will be deleted soon.
        $downloadUrl = ipRequest()->getPost('downloadUrl');
        $md5 = ipRequest()->getPost('md5');

        $fs = new Helper\FileSystem();
        $fs->rm(ipFile('file/tmp/update/extracted/'));

        $this->downloadArchive(
            $downloadUrl,
            $md5,
            ipFile('file/tmp/' . 'update/ImpressPages.zip')
        );
        $this->extractArchive(ipFile('file/tmp/update/DemoticCMS.zip'), ipFile('file/tmp/update/extracted/'));

        $backupDir = ipFile('file/tmp/' . date('Y-m-d H.i.s'));
        $fs->rm($backupDir);
        $fs->createWritableDir($backupDir);
        $fs->cpContent(ipFile('Demotic/'), $backupDir);
        $fs->makeWritable(ipFile('Demotic/'));
        $fs->clean(ipFile('Demotic/'));
        $fs->cpContent(ipFile('file/tmp/update/extracted/Demotic/'), ipFile('Demotic/'));

    }


    private function downloadArchive($scriptUrl, $md5checksum, $archivePath)
    {

        if (file_exists($archivePath)) {
            if (md5_file($archivePath) == $md5checksum) {
                return; //everything is fine. We have the right archive in place
            } else {
                //archive checksum is wrong. Remove the archive;
                unlink($archivePath);
            }
        }

        //download archive
        $downloadHelper = new Helper\Net();
        $downloadHelper->downloadFile($scriptUrl, $archivePath);
        if (md5_file($archivePath) != $md5checksum) {
            throw new UpdateException("Downloaded archive doesn't mach md5 checksum");
        }
    }

    private function extractArchive($archivePath, $extractedPath)
    {
        $fs = new Helper\FileSystem();
        $fs->createWritableDir($extractedPath);
        $fs->clean($extractedPath);

        require_once(ipFile('Demotic/Gebtu/PclZip.php'));
        $zip = new \PclZip($archivePath);
        $status = $zip->extract(PCLZIP_OPT_PATH, $extractedPath, PCLZIP_OPT_REMOVE_PATH, 'DemoticCMS');

        if (!$status) {
            throw new UpdateException("Archive extraction failed");
        }

    }

}
