<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


namespace Demotic\Gebtu\Update;


class Model
{

    /**
     * DON'T USE THIS FUNCTION IN THE CORE. UPDATE SCRIPT WILL FAIL IF THIS CLASS WILL BE LOADED BEFORE NEW CORE IS DOWNLOADED.
     * @return int
     */
    public static function getDbVersion()
    {
        return 111; //CHANGE_ON_VERSION_UPDATE
    }

    public static function migrationsAvailable()
    {
        $curDbVersion = ipStorage()->get('Demotic', 'dbVersion');
        return $curDbVersion < Model::getDbVersion();
    }

    public static function runMigrations()
    {
        $curDbVersion = ipStorage()->get('Demotic', 'dbVersion');
        for ($i = $curDbVersion + 1; $i <= Model::getDbVersion(); $i++) {
            $migrationMethod = 'update_' . $i;
            if (method_exists(__NAMESPACE__ . '\Migration', $migrationMethod)) {
                Migration::$migrationMethod();
            }
            ipStorage()->set('Demotic', 'dbVersion', $i);
        }
    }
}
