<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Translations;

class Translator
{
    /**
     * @var $translator \Laminas\I18n\Translator\Translator
     */
    protected $translator;

    protected $publicLocale;
    protected $adminLocale;


    protected $domains = [];

    protected $adminDomains = [];

    public function __construct()
    {
        $this->translator = new \Laminas\I18n\Translator\Translator();
        $this->translator->getPluginManager()->setInvokableClass('json', 'Demotic\Gebtu\Translations\JsonLoader');

        $this->setLocale('en');
        $this->setAdminLocale('en');
    }

    public function addTranslationFilePattern($type, $directory, $pattern, $domain)
    {
        $this->translator->addTranslationFilePattern(
            $type,
            $directory,
            $pattern,
            $domain
        );

        $this->domains[$domain] = true;

        if (substr($domain, -6) == '-admin') {
            $this->adminDomains[$domain] = 'admin';
        }

        return $this;
    }

    public function translate($text, $domain)
    {
        if (isset($this->adminDomains[$domain]) && $this->adminLocale != $this->publicLocale) {
            $this->translator->setLocale($this->adminLocale);
            $result = $this->translator->translate($text, $domain);
            $this->translator->setLocale($this->publicLocale);

            return $result;
        }

        return $this->translator->translate($text, $domain);
    }

    public function setLocale($locale)
    {
        $this->publicLocale = $locale;
        $this->translator->setLocale($locale);
        return $this;
    }

    public function getLocale()
    {
        return $this->publicLocale;
    }

    public function setAdminLocale($locale)
    {
        $this->adminLocale = $locale;
        return $this;
    }

    public function getAdminLocale()
    {
        return $this->adminLocale;
    }

    public function getRegisteredDomains()
    {
        return array_keys($this->domains);
    }
}
