<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Text;

/**
 * replaces special characters in a string
 * @package Library
 */
class Specialchars
{
    /**
     * replace special characters for directory
     * @param string $string directory name to replace
     * @return string string without special characters
     */
    public static function dirName($string)
    {
        $new_string = preg_replace("/[^a-zA-Z0-9]/", "_", $string);
        //$new_string = preg_replace("/[^a-zA-Z0-9s]/", "", $string);
        return $new_string;
    }

    /**
     * replace special characters for file name
     * @param string $string file name to replace
     * @return string string without special characters
     */
    public static function fileName($string)
    {
        $new_string = preg_replace("/[^.a-zA-Z0-9]/", "_", $string);
        //$new_string = preg_replace("/[^a-zA-Z0-9s]/", "", $string);
        return $new_string;
    }

    public static function url($string)
    {
        $url = mb_strtolower($string);
        $url = \Demotic\Gebtu\Text\Transliteration::transform($url);
        $replace = array(
            " " => "-",
            "/" => "-",
            "\\" => "-",
            "\"" => "-",
            "\'" => "-",
            "„" => "-",
            "“" => "-",
            "&" => "-",
            "%" => "-",
            "`" => "-",
            "!" => "-",
            "@" => "-",
            "#" => "-",
            "$" => "-",
            "^" => "-",
            "*" => "-",
            "(" => "-",
            ")" => "-",
            "{" => "-",
            "}" => "-",
            "[" => "-",
            "]" => "-",
            "|" => "-",
            "~" => "-",
            "." => "-",
            "+" => "-",
            "'" => "-",
            "?" => "-",
            ":" => "-",
            ";" => "-",
            "," => "-",
        );
        $url = strtr($url, $replace);

        $url = preg_replace('/-+/', '-', $url);

        return $url;

    }

}
