<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


/**
 * Created by PhpStorm.
 * User: maskas
 * Date: 2/19/14
 * Time: 10:17 PM
 */

namespace Demotic\Gebtu\System;


class Submenu
{
    public static function getModuleNames()
    {
        return array('System', 'Administrators', 'Log', 'Email');
    }

    public static function getSubmenuUrls()
    {
        $moduleNames = self::getModuleNames();
        $urls = [];
        foreach ($moduleNames as $moduleName) {
            $urls[] = ipActionUrl(array('aa' => $moduleName . '.index'));
        }

        return $urls;
    }

    protected static function getControllerNames()
    {
        $controllerNames = [];
        foreach (self::getModuleNames() as $name) {
            $controllerNames[] = 'Demotic\Gebtu\\' . $name . '\AdminController';
        }
        return $controllerNames;
    }


    public static function isControllerInSystemSubmenu()
    {
        return in_array(ipRoute()->controllerClass(), self::getControllerNames());
    }

    /**
     * @return \Demotic\Menu\Item[]
     */
    public static function getSubmenuItems()
    {
        $modules = self::getModuleNames();

        $submenuItems = [];

        if (0) { // It is for translation engine to find following strings
            __('Content', 'Demotic-admin');
            __('Pages', 'Demotic-admin');
            __('Design', 'Demotic-admin');
            __('Plugins', 'Demotic-admin');
            __('Config', 'Demotic-admin');
            __('Languages', 'Demotic-admin');
            __('System', 'Demotic-admin');
        }

        foreach ($modules as $module) {
            $menuItem = new \Demotic\Menu\Item();
            $title = $module;
            if ($title == 'Email') {
                $title = 'Email log';
            }
            $menuItem->setTitle(__($title, 'Demotic-admin', false)); //
            $menuItem->setUrl(ipActionUrl(array('aa' => $module . '.index')));
            if (ipRoute()->controllerClass() == 'Demotic\Gebtu\\' . $module . '\AdminController') {
                $menuItem->markAsCurrent(true);
            }
            if (ipAdminPermission($module)) {
                $submenuItems[] = $menuItem;
            }
        }
        return $submenuItems;
    }

}
