<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\System;


class Helper
{

    public static function recoveryPageForm()
    {
        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);

        $pages = ipDb()->selectAll('page', 'id, title', array('isDeleted' => 1));

        foreach ($pages as $page) {
            $field = new \Demotic\Form\Field\Checkbox(
                array(
                    'name' => 'page[]',
                    'label' => $page['title'],
                    'value' => false,
                    'postValue' => $page['id']
                ));
            $form->addField($field);
        }

        return $form;
    }

    public static function emptyPageForm()
    {
        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);

        $pages = ipDb()->selectAll('page', 'id, title', array('isDeleted' => 1));

        foreach ($pages as $page) {
            $field = new \Demotic\Form\Field\Checkbox(
                array(
                    'name' => 'page[]',
                    'label' => $page['title'],
                    'value' => true,
                    'postValue' => $page['id']
                ));
            $form->addField($field);
        }

        return $form;
    }

}
