<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\System;


class Filter
{
    public static function ipAdminSystemSubmenu($menu, $info)
    {
        if (Submenu::isControllerInSystemSubmenu()) {
            $menu = array_merge($menu, Submenu::getSubmenuItems());
            return $menu;
        }
        return null;
    }

    /**
     * @param \Demotic\Menu\Item[] $menu
     * @param $info
     */
    public static function ipAdminMenu($menu, $info)
    {
        $urls = Submenu::getSubmenuUrls();
        $filteredMenu = [];

        //remove menu items that are in submenu
        foreach ($menu as $menuItem) {
            if (!in_array($menuItem->getUrl(), $urls)) {
                $filteredMenu[] = $menuItem;
            }
        }


        $submenuItems = Submenu::getSubmenuItems();
        if (!empty($submenuItems)) {
            $firstSubmenuItem = $submenuItems[0];
            $newItem = new \Demotic\Gebtu\Admin\MenuItem();
            $newItem->setTitle(__('System', 'Demotic-admin', false));
            $newItem->setUrl($firstSubmenuItem->getUrl());
            $newItem->setIcon('fa-cogs');
            $filteredMenu[] = $newItem;
        }

        return $filteredMenu;
    }
}
