<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Repository;

abstract class Transform
{
    /**
     * @param string $sourceFile original file
     * @param string $destinationFile destination file with extension provided by getNewExtension
     * @return mixed
     */
    public abstract function transform($sourceFile, $destinationFile);

    /**
     * Transform function might want to change file extension.
     * @param string $sourceFile original file
     * @param string $ext original file extension
     */
    public function getNewExtension($sourceFile, $ext)
    {
        return $ext; //by default extension doesn't change. Overwrite this method to return different extension
    }

    public function getParamStr()
    {
        return serialize(get_object_vars($this));

    }

    final public function getFingerprint()
    {
        return md5(__CLASS__ . ':' . $this->getParamStr());
    }

}
