<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Repository;


class Filter
{
    public static function ipReflectionExtension($ext, $data)
    {
        if (empty($data['source']) || empty($data['options'])) {
            return null;
        }
        $options = $data['options'];


        switch ($options['type']) {
            case 'crop':
                $requiredParams = array(
                    'x1',
                    'y1',
                    'x2',
                    'y2',
                    'width',
                    'height'
                );
                $missing = array_diff($requiredParams, array_keys($options));
                if ($missing) {
                    throw new \Demotic\Exception\Repository\Transform("Missing required parameters: " . implode(
                        ', ',
                        $missing
                    ));
                }
                if (isset($options['quality'])) {
                    $quality = $options['quality'];
                } else {
                    $quality = null;
                }
                $transform = new Transform\ImageCrop($options['x1'], $options['y1'], $options['x2'], $options['y2'], $options['width'], $options['height'], $quality);
                return $transform->getNewExtension($data['source'], $ext);
                break;
            case 'center':
                $requiredParams = array(
                    'width',
                    'height'
                );
                $missing = array_diff($requiredParams, array_keys($options));
                if ($missing) {
                    throw new \Demotic\Exception\Repository\Transform("Missing required parameters: " . implode(
                        ', ',
                        $missing
                    ));
                }
                if (isset($options['quality'])) {
                    $quality = $options['quality'];
                } else {
                    $quality = null;
                }
                $transform = new Transform\ImageCropCenter($options['width'], $options['height'], $quality);
                return $transform->getNewExtension($data['source'], $ext);
                break;
            case 'fit':
                $requiredParams = array(
                    'width',
                    'height'
                );
                $missing = array_diff($requiredParams, array_keys($options));
                if ($missing) {
                    throw new \Demotic\Exception\Repository\Transform("Missing required parameters: " . implode(
                        ', ',
                        $missing
                    ));
                }
                if (isset($options['quality'])) {
                    $quality = $options['quality'];
                } else {
                    $quality = null;
                }
                if (isset($options['forced'])) {
                    $forced = $options['forced'];
                } else {
                    $forced = false;
                }
                $transform = new Transform\ImageFit($options['width'], $options['height'], $quality, $forced);
                return $transform->getNewExtension($data['source'], $ext);
                break;
            case 'copy':

                return $ext;
                break;
            default:
                return $ext;
        }
    }

}
