<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
namespace Demotic\Gebtu\Repository;


class Event
{
    public static function ipBeforeController()
    {

        if (ipIsManagementState() || ipRoute()->isAdmin() || ipRequest()->getQuery('ipDesignPreview')) {
            ipAddJs('Demotic/Gebtu/Core/assets/js/jquery-ui/jquery-ui.js');
            ipAddJs('Demotic/Gebtu/Repository/assets/ipRepository.js');
            ipAddJs('Demotic/Gebtu/Repository/assets/ipRepositoryUploader.js');
            ipAddJs('Demotic/Gebtu/Repository/assets/ipRepositoryAll.js');
            ipAddJs('Demotic/Gebtu/Repository/assets/ipRepositoryBuy.js');
            ipAddJs('Demotic/Gebtu/System/assets/market.js');
            ipAddJs('Demotic/Gebtu/Core/assets/js/easyXDM/easyXDM.min.js');

            $marketUrl = ipConfig()->get('imageMarketUrl', ipConfig()->protocol() . '://market.impresspages.org/images-v1/');

            $popupData = array(
                'marketUrl' => $marketUrl,
                'allowUpload' => ipAdminPermission('Repository upload'),
                'allowRepository' => ipAdminPermission('Repository')
            );

            ipAddJsVariable('ipRepositoryHtml', ipView('view/popup.php', $popupData)->render());
            ipAddJsVariable(
                'ipRepositoryTranslate_confirm_delete',
                __('Are you sure you want to delete selected files?', 'Demotic-admin')
            );
            ipAddJsVariable(
                'ipRepositoryTranslate_delete_warning',
                __('Some of the selected files are still used somewhere on your website. Do you still want to remove them? ', 'Demotic-admin')
            );
        }


    }

}


