<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Pages;


class Helper
{

    public static function pagesGridConfig($parentId)
    {
        $config = array(
            'table' => 'page',
            'title' => false,
            'allowCreate' => false,
            'allowSearch' => false,
            'allowDelete' => false,
            'allowUpdate' => false,
            'sortField' => 'pageOrder',
            'pageSize' => ipGetOption('Pages.pageListSize', 30),
            'layout' => 'Demotic/Gebtu/Pages/view/grid/layout.php',
            'pagerSize' => 5,
            'pageVariableName' => 'gpage',
            'filter' => 'isDeleted = 0 and parentId = ' . (int)$parentId, //rename to sqlWhere
            'fields' => array(
                array(
                    'label' => __('Title', 'Demotic-admin', false),
                    'field' => 'title'
                )
            )
        );

        $config = ipFilter('ipPageListGridConfig', $config, array('parentId' => $parentId));

        return $config;
    }


    public static function languageList()
    {
        $answer = [];
        $languages = ipContent()->getLanguages();
        foreach ($languages as $language) {
            $answer[] = array(
                'id' => $language->getId(),
                'title' => $language->getTitle(),
                'abbreviation' => $language->getAbbreviation(),
                'code' => $language->getCode(),
            );
        }
        return $answer;
    }

    public static function menuForm($menuId)
    {
        $menu = Model::getPage((int)$menuId);

        if (!$menu) {
            throw new \Demotic\Exception('Menu not found.', array('id' => $menuId));
        }

        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'aa',
                'value' => 'Pages.updateMenu'
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'id',
                'value' => $menu['id']
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'title',
                'label' => __('Title', 'Demotic-admin', false),
                'value' => $menu['title']
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'alias',
                'label' => __('Menu name (used in PHP code)', 'Demotic-admin', false),
                'value' => $menu['alias']
            ));
        $form->addField($field);

        $layouts = \Demotic\Gebtu\Design\Service::getLayouts();

        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'layout',
                'label' => __('Layout', 'Demotic-admin', false),
                'value' => $menu['layout'],
                'values' => $layouts,
            ));
        $form->addField($field);

        $values = array(
            array('tree', __('Tree (for menu)', 'Demotic-admin', false)),
            array('list', __('List (for blogs)', 'Demotic-admin', false)),
        );
        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'type',
                'label' => __('Type', 'Demotic-admin', false),
                'value' => $menu['type'],
                'values' => $values,
            ));
        $form->addField($field);

        $form = ipFilter('ipMenuForm', $form, array('menuId' => $menuId));

        return $form;
    }

    public static function pagePropertiesForm($pageId)
    {
        $page = new \Demotic\Page($pageId);

        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);


        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'aa',
                'value' => 'Pages.updatePage'
            ));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'pageId',
                'value' => $pageId
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'title',
                'label' => __('Title', 'Demotic-admin', false),
                'value' => $page->getTitle()
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'urlPath',
                'label' => __('URL path', 'Demotic-admin', false),
                'value' => $page->getUrlPath(),
            ));
        //Prevent updating of the homepage URL path ( $pageId == 4 ) which by default is set to an empty string during installation
        if($pageId == 4) { $field->addAttribute('disabled', 'disabled'); }
        
        $form->addField($field);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'isVisible',
                'label' => __('Visible', 'Demotic-admin', false),
                'value' => $page->isVisible()
            ));
        $form->addField($field);


        $layouts = \Demotic\Gebtu\Design\Service::getLayouts();

        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'layout',
                'label' => __('Layout', 'Demotic-admin', false),
                'values' => $layouts,
                'value' => $page->getLayout()
            ));
        $form->addField($field);

        $fieldset = new \Demotic\Form\Fieldset(__('SEO', 'Demotic-admin', false));
        $form->addFieldset($fieldset);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'metaTitle',
                'label' => __('Meta title', 'Demotic-admin', false),
                'value' => $page->getMetaTitle()
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'keywords',
                'label' => __('Keywords', 'Demotic-admin', false),
                'value' => $page->getKeywords()
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Textarea(
            array(
                'name' => 'description',
                'label' => __('Description', 'Demotic-admin', false),
                'value' => $page->getDescription()
            ));
        $form->addField($field);


        $fieldset = new \Demotic\Form\Fieldset(__('Other', 'Demotic-admin', false));
        $form->addFieldset($fieldset);

        $field = new \Demotic\Form\Field\Url(
            array(
                'name' => 'redirectUrl',
                'label' => __('Redirect', 'Demotic-admin', false),
                'value' => $page->getRedirectUrl()
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'isDisabled',
                'label' => __('Disabled', 'Demotic-admin', false),
                'value' => $page->isDisabled(),
                'note' => __('Won\'t be clickable in menu if selected.', 'Demotic-admin', false),
            ));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'isSecured',
                'label' => __('Secured', 'Demotic-admin', false),
                'value' => $page->isSecured(),
                'note' => __('Won\'t be accessible to view even knowing the URL.', 'Demotic-admin', false),
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'isBlank',
                'label' => __('Open in new window', 'Demotic-admin', false),
                'value' => $page->isBlank()
            ));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'alias',
                'label' => __('Alias (used in code)', 'Demotic-admin', false),
                'value' => $page->getAlias()
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Date(
            array(
                'name' => 'createdAt',
                'label' => __('Created on', 'Demotic-admin', false),
                'value' => date('Y-m-d', strtotime($page->getCreatedAt()))
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Date(
            array(
                'name' => 'updatedAt',
                'label' => __('Updated on', 'Demotic-admin', false),
                'value' => date('Y-m-d', strtotime($page->getUpdatedAt()))
            ));
        $form->addField($field);

        $form = ipFilter('ipPagePropertiesForm', $form, array('pageId' => $pageId));

        return $form;
    }

    public static function addPageForm()
    {
        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);

        $form->setAjaxSubmit(false);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'title',
                'label' => __('Title', 'Demotic-admin', false)
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'isVisible',
                'label' => __('Visible', 'Demotic-admin', false),
                'value' => !ipGetOption('Pages.hideNewPages', 0)
            ));
        $form->addField($field);

        $values = array(
            array('top', __('Top', 'Demotic-admin', false)),
            array('above', __('Above selected', 'Demotic-admin', false)),
            array('child', __('Child of selected', 'Demotic-admin', false)),
            array('below', __('Below selected', 'Demotic-admin', false)),
            array('bottom', __('Bottom', 'Demotic-admin', false)),
        );
        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'position',
                'label' => __('Position', 'Demotic-admin', false),
                'values' => $values,
                'value' => 'below'
            ));
        $form->addField($field);

        return $form;
    }

    public static function addMenuForm()
    {
        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'title',
                'label' => __('Title', 'Demotic-admin', false)
            ));
        $form->addField($field);

        $values = array(
            array('tree', __('Tree (for menu)', 'Demotic-admin', false)),
            array('list', __('List (for blogs)', 'Demotic-admin', false)),
        );
        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'type',
                'label' => __('Type', 'Demotic-admin', false),
                'values' => $values,
            ));
        $form->addField($field);

        return $form;
    }


}
