<?php

/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Languages;


class Helper
{
    public static function getAddForm()
    {
        $form = new \Demotic\Form();

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'aa',
                'value' => 'Languages.addLanguage'
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Select(
            array(
                'name' => 'languageCode',
                'values' => self::getLanguageSelectValues()
            ));
        $form->addField($field);

        return $form;
    }


    private static function getLanguageSelectValues()
    {
        $answer = [];
        $languages = Fixture::languageList();
        foreach ($languages as $key => $language) {
            $answer[] = array(
                $key,
                $language['name'] . ' (' . $language['nativeName'] . ')'
            );
        }


        usort($answer, array(__CLASS__, 'cmp'));

        return $answer;
    }


    protected static function cmp($a, $b)
    {
        if ($a[0] == $b[0]) {
            return 0;
        }
        return ($a[0] < $b[0]) ? -1 : 1;
    }

}



