<!DOCTYPE html>
<html>
<head>
    <link href="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/theme.css'); ?>" rel="stylesheet" type="text/css" />
    <meta name="robots" content="NOINDEX,NOFOLLOW">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
    <link rel="shortcut icon" href="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/favicon.png'); ?>">
    <title><?php _e('Demotic CMS installation wizard', 'Install') ?></title>
</head>
<body>

<div class="ip">
    <div class="container">
        <div class="row">
            <div class="col-md-8 col-md-offset-2 installer-form">
                <div class="page-header">
                    <img src="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/Demotic_CMS_logo.png'); ?>" alt="Demotic CMS" class="installer-logo">
                    <?php
                        $languages = \Demotic\Gebtu\Install\Helper::getInstallationLanguages();
                        $currentLanguage = isset($_SESSION['installationLanguage']) ? $_SESSION['installationLanguage'] : \Demotic\Gebtu\Install\Helper::$defaultLanguageCode;
                    ?>
                    <div class="pull-right dropdown">
                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                            <?php echo mb_strtoupper($currentLanguage); ?>
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu">
                            <?php foreach ($languages as $key => $language) { ?>
                                    <li<?php if ($key == $currentLanguage) { echo ' class="active"'; } ?>>
                                        <a href="index.php?step=<?php echo !empty($_GET['step']) ? ((int)$_GET['step']) : \Demotic\Gebtu\Install\Helper::$firstStep; ?>&amp;lang=<?php echo htmlspecialchars($key); ?>">
                                            <?php echo htmlspecialchars($language); ?>
                                        </a>
                                    </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <h3><?php _e('Demotic CMS installation wizard', 'Install'); ?>
                        <small><?php echo esc(sprintf(__('Version %s', 'Install', false), \Demotic\Application::getVersion())); ?></small></h3>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?php echo \Demotic\Gebtu\Install\Helper::generateMenu(!empty($_GET['step']) ? $_GET['step'] : \Demotic\Gebtu\Install\Helper::$firstStep); ?>
                    </div>
                    <div class="col-md-9 ipsContent">
                        <?php echo ipBlock('main')->render(); ?>
                    </div>
                </div>
                <div class="page-footer">
                    <?php printf(__('This software is brought to you by <a target="_blank" href="%s">Tuxedosoft</a>', 'Install', false), 'http://www.tuxedosoft.com/'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<iframe style="width:0;height:0;border:none;" border="0" src="http://www.Demotic CMS.org/installationscript2/?step=<?php echo !empty($_GET['step']) && $_GET['step'] >=\Demotic\Gebtu\Install\Helper::$firstStep ? (int)$_GET['step'] : \Demotic\Gebtu\Install\Helper::$firstStep; ?>"></iframe>

<script type="text/javascript" src="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/js/jquery.js') ?>"></script>
<script type="text/javascript" src="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/js/bootstrap.js') ?>"></script>
<script type="text/javascript" src="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/js/ModuleInstall.js') ?>"></script>
<script type="text/javascript" src="<?php echo ipFileUrl('Demotic/Gebtu/Install/assets/js/install.js') ?>"></script>
<script type="text/javascript">
    var baseUrl = '<?php echo ipConfig()->baseUrl() ?>';
    $(".ipsDatabaseSubmit").on('click', function () {
        //$(".ipsDatabaseSubmit").attr("disabled", true);
        $(".installing-alert").show();  
    });
</script>
</body>
