<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Install;


class PageAssets extends \Demotic\Gebtu\PageAssets
{
    public function generateJavascript()
    {
        $cacheVersion = $this->getCacheVersion();
        $javascriptFiles = $this->getJavascript();

        $javascriptFilesSorted = [];
        foreach ($javascriptFiles as $level) {
            foreach ($level as &$file) {
                if ($file['type'] == 'file' && $file['cacheFix']) {
                    $file['value'] .= (strpos($file['value'], '?') !== false ? '&' : '?') . $cacheVersion;
                }
            }
            $javascriptFilesSorted = array_merge($javascriptFilesSorted, $level);
        }


        $data = array(
            'ip' => array(
                'baseUrl' => ipConfig()->baseUrl(),
                'languageId' => null,
                'languageUrl' => '',
                'theme' => ipConfig()->get('theme'),
                'pageId' => null,
                'securityToken' => \Demotic\ServiceLocator::application()->getSecurityToken(),
                'developmentEnvironment' => ipConfig()->isDevelopmentEnvironment(),
                'debugMode' => ipconfig()->isDebugMode(),
                'isManagementState' => false,
                'isAdminState' => false,
                'isAdminNavbarDisabled' => false
            ),
            'javascriptVariables' => $this->getJavascriptVariables(),
            'javascript' => $javascriptFilesSorted,
        );
        return ipView(ipFile('Demotic/Gebtu/Config/view/javascript.php'), $data)->render();
    }

    protected function getCacheVersion()
    {
        return 1;
    }

    protected function getCurrentRevision()
    {
        return array(
            'revisionId' => 1,
        );
    }

}
