<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
namespace Demotic\Gebtu\InlineManagement;


class Event
{
    public static function ipBeforeController()
    {

        if (ipIsManagementState()) {
            if (ipConfig()->isDebugMode()) {
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/inlineManagement.js');
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/inlineManagementControls.js');
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/inlineManagementImage.js');
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/inlineManagementLogo.js');
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/inlineManagementText.js');
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/src/jquery.fontselector.js');
            } else {
                ipAddJs('Demotic/Gebtu/InlineManagement/assets/inlineManagement.min.js');
            }

            ipAddJsVariable('ipModuleInlineManagementControls', ipView('view/management/controls.php')->render());

            ipAddJs('Demotic/Gebtu/Content/assets/jquery.ip.uploadImage.js');

            ipAddJs('Demotic/Gebtu/Core/assets/js/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js');
            ipAddCss('Demotic/Gebtu/Core/assets/js/bootstrap-colorpicker/css/bootstrap-colorpicker.css');
        }


    }

    public static function ipUrlChanged($info)
    {
        $httpExpression = '/^((http|https):\/\/)/i';
        if (!preg_match($httpExpression, $info['oldUrl'])) {
            return;
        }
        if (!preg_match($httpExpression, $info['newUrl'])) {
            return;
        }
        Model::updateUrl($info['oldUrl'], $info['newUrl']);
    }
}


