<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\InlineManagement;


class Dao
{

    const MODULE_NAME = 'inline_management';
    const PREFIX_TEXT = 'txt_';
    const PREFIX_IMAGE = 'img_';
    const PREFIX_LOGO = 'logo_';
    protected  $inlineValueService;

    public function __construct()
    {
        $this->inlineValueService = new \Demotic\Gebtu\InlineValue\Service(self::MODULE_NAME);
    }


    // GET
    public function getValue($prefix, $key, $languageId, $pageId)
    {
        return $this->inlineValueService->getValue($prefix . $key, $languageId, $pageId);
    }

    public function getPageValue($prefix, $key, $languageId, $pageId)
    {
        return $this->inlineValueService->getPageValue($prefix . $key, $languageId, $pageId);
    }

    public function getLanguageValue($prefix, $key, $languageId)
    {
        return $this->inlineValueService->getLanguageValue($prefix . $key, $languageId);
    }

    public function getGlobalValue($prefix, $key)
    {
        return $this->inlineValueService->getGlobalValue($prefix . $key);
    }

    public function setPageValue($prefix, $key, $languageId, $pageId, $value)
    {
        $this->inlineValueService->setPageValue($prefix . $key, $languageId, $pageId, $value);
    }


    public function setLanguageValue($prefix, $key, $languageId, $value)
    {
        $this->inlineValueService->setLanguageValue($prefix . $key, $languageId, $value);
    }

    public function setGlobalValue($prefix, $key, $value)
    {
        $this->inlineValueService->setGlobalValue($prefix . $key, $value);
    }

    // DELETE
    public function deletePageValue($prefix, $key, $pageId)
    {
        $this->inlineValueService->deletePageValue($prefix . $key, $pageId);
    }

    public function deleteLanguageValue($prefix, $key, $languageId)
    {
        $this->inlineValueService->deleteLanguageValue($prefix . $key, $languageId);
    }

    public function deleteGlobalValue($prefix, $key)
    {
        $this->inlineValueService->deleteGlobalValue($prefix . $key);
    }

    /**
     * Last get operation scope
     * @return \Demotic\Gebtu\InlineValue\Entity\Scope
     */
    public function getLastOperationScope()
    {
        return $this->inlineValueService->getLastOperationScope();
    }

}
