<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Grid;


class Worker
{

    protected $config = null;
    protected $model = null;

    /**
     * @param array $config
     */
    public function __construct($config)
    {
        $this->config = $config;
        if (empty($this->config['type'])) {
            $this->config['type'] = 'table';
        }
    }

    public function handleMethod(\Demotic\Request $request)
    {
        switch ($this->config['type']) {
            case 'table':
                $this->model = new Model\Table($this->config, $request);
                break;
            default:
                throw new \Demotic\Exception('Undefined Grid type');
        }
        $commands = $this->model->handleMethod();
        return $commands;
    }


}
