<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Grid\Model\Field;


class Checkbox extends \Demotic\Gebtu\Grid\Model\Field
{
    protected $field = '';
    protected $label = '';
    protected $defaultValue = '';

    public function __construct($fieldConfig, $wholeConfig)
    {
        if (empty($fieldConfig['field'])) {
            throw new \Demotic\Exception('\'field\' option required for text field');
        }
        $this->field = $fieldConfig['field'];

        if (!empty($fieldConfig['label'])) {
            $this->label = $fieldConfig['label'];
        }

        if (!empty($fieldConfig['defaultValue'])) {
            $this->defaultValue = $fieldConfig['defaultValue'];
        }
    }

    public function preview($recordData)
    {
        if (!empty($recordData[$this->field])) {
            return __('Yes', 'Demotic-admin');
        } else {
            return __('No', 'Demotic-admin');
        }
    }

    public function createField()
    {
        $field = new \Demotic\Form\Field\Checkbox(array(
            'label' => $this->label,
            'name' => $this->field,
            'layout' => $this->layout,
            'attributes' => $this->attributes
        ));
        $field->setValue($this->defaultValue);
        return $field;
    }

    public function createData($postData)
    {
        return array($this->field => !empty($postData[$this->field]));
    }

    public function updateField($curData)
    {
        $field = new \Demotic\Form\Field\Checkbox(array(
            'label' => $this->label,
            'name' => $this->field,
            'layout' => $this->layout,
            'attributes' => $this->attributes
        ));
        if (isset($curData[$this->field])){
        $field->setValue($curData[$this->field]);
        }
        return $field;
    }

    public function updateData($postData)
    {
        return array($this->field => !empty($postData[$this->field]));
    }


    public function searchField($searchVariables)
    {
        $values = array(
            array(null, ''),
            array('1', __('Yes', 'Demotic-admin', false)),
            array('0', __('No', 'Demotic-admin', false))

        );


        $field = new \Demotic\Form\Field\Select(array(
            'label' => $this->label,
            'name' => $this->field,
            'values' => $values,
            'value' => null,
            'layout' => $this->layout,
            'attributes' => $this->attributes
        ));
        if (isset($searchVariables[$this->field])) {
            $field->setValue($searchVariables[$this->field]);
        }
        return $field;

    }

    public function searchQuery($searchVariables)
    {
        if (isset($searchVariables[$this->field]) && $searchVariables[$this->field] !== '') {
            if ($searchVariables[$this->field]) {
                return '`' . $this->field . '`';
            } else {
                return 'not `' . $this->field . '`';
            }

        }
        return null;
    }
}
