<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Email;


class AdminController extends \Demotic\GridController
{



    protected function config()
    {
        return array(
            'type' => 'table',
            'allowCreate' => false,
            'allowUpdate' => false,
            'allowDelete' => false,
            'orderField' => 'id',
            'orderDirection' => 'desc',
            'table' => 'email_queue',
            'title' => __('Email log', 'Demotic-admin', false),
            'actions' => [],
            'fields' => array(
                array(
                    'label' => __('Subject', 'Demotic-admin', false),
                    'field' => 'subject'
                ),
                array(
                    'label' => __('Recipient name', 'Demotic-admin', false),
                    'field' => 'toName',
                    'preview' => false
                ),
                array(
                    'label' => __('Recipient email', 'Demotic-admin', false),
                    'field' => 'to',
                    'preview' => __CLASS__ . '::to'
                ),
                array(
                    'label' => __('Sender name', 'Demotic-admin', false),
                    'field' => 'fromName',
                    'preview' => false
                ),
                array(
                    'label' => __('Sender email', 'Demotic-admin', false),
                    'field' => 'from',
                    'preview' => __CLASS__ . '::from'
                ),
                array(
                    'label' => __('Sent at', 'Demotic-admin', false),
                    'field' => 'send',
                    'preview' => true
                ),
                array(
                    'label' => __('Attachment', 'Demotic-admin', false),
                    'field' => 'fileNames'
                ),
                array(
                    'label' => '',
                    'field' => 'id',
                    'preview' => '<a href="#" class="ipsEmailPreview">' . __('Preview', 'Demotic-admin') . '</a>',
                    'allowUpdate' => false,
                    'allowInsert' => false,
                    'allowSearch' => false
                )
            )
        );
    }

    public function index()
    {
        ipAddJs('assets/email.js');
        ipAddCss('assets/email.css');

        $previewModal = ipView('view/previewModal.php');
        return parent::index() . $previewModal;
    }


    public function preview()
    {
        $id = ipRequest()->getQuery('id');
        if (!$id) {
            throw new \Demotic\Exception('Email not found');
        }
        $email = Db::getEmail($id);
        $viewData = array(
            'email' => $email
        );
        $content = ipView('view/preview.php', $viewData);
        $response = new \Demotic\Response($content);
        return $response;
    }




    public static function to($value, $recordData)
    {
        return esc($recordData['toName'] . ' ' . $value);
    }

    public static function from($value, $recordData)
    {
        return esc($recordData['fromName'] . ' ' . $value);
    }


}
