<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


/**
 * Created by PhpStorm.
 * User: mangirdas
 * Date: 8/19/14
 * Time: 7:10 PM
 */

namespace Demotic\Gebtu\Ecommerce;


class SiteController
{

    public function paymentSelection($key)
    {
        $data = Model::getPaymentData($key);
        $paymentMethods = Model::collectPaymentMethods($data);

        $paymentMethodName = ipRequest()->getPost('paymentMethod');
        if ($paymentMethodName) {
            //redirect to selected payment page
            foreach($paymentMethods as $paymentMethod) {
                if ($paymentMethod->name() == $paymentMethodName) {
                    $paymentUrl = $paymentMethod->paymentUrl($data['data']);
                    return new \Demotic\Response\Json(array('redirect' => $paymentUrl));
                }
            }
        }

        //display all available payment methods
        ipAddJs('assets/paymentSelection.js');
        ipAddCss('assets/payments.css');
        $response = ipView('view/selectPayment.php', array('paymentMethods' => $paymentMethods));
        $response = ipFilter('ipPaymentSelectPageResponse', $response, array('paymentKey' => $key));
        return $response;

    }


    public function subscriptionPaymentSelection($key)
    {
        $data = Model::getPaymentData($key);
        $paymentMethods = Model::collectSubscriptionPaymentMethods($data);

        $paymentMethodName = ipRequest()->getPost('paymentMethod');
        if ($paymentMethodName) {
            //redirect to selected payment page
            foreach($paymentMethods as $paymentMethod) {
                if ($paymentMethod->name() == $paymentMethodName) {
                    $paymentUrl = $paymentMethod->paymentUrl($data['data']);
                    return new \Demotic\Response\Json(array('redirect' => $paymentUrl));
                }
            }
        }

        //display all available payment methods
        ipAddJs('assets/paymentSelection.js');
        ipAddCss('assets/payments.css');
        $response = ipView('view/selectPayment.php', array('paymentMethods' => $paymentMethods));
        $response = ipFilter('ipSubscriptionPaymentSelectPageResponse', $response, array('paymentKey' => $key));
        return $response;

    }
}
