<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

/**
 * Created by PhpStorm.
 * User: mangirdas
 * Date: 8/20/14
 * Time: 10:57 AM
 */

namespace Demotic\Gebtu\Ecommerce;


class Model
{
    /**
     * @param $paymentData
     * @return \Demotic\Payment[]
     */
    public static function collectPaymentMethods($paymentData)
    {
        return ipFilter('ipPaymentMethods', [], $paymentData);
    }

    /**
     * @param $paymentData
     * @return \Demotic\SubscriptionPayment[]
     */
    public static function collectSubscriptionPaymentMethods($paymentData)
    {
        return ipFilter('ipSubscriptionPaymentMethods', [], $paymentData);
    }


    /**
     * @param array $paymentData
     * @return string unique 32 character key of stored data
     */
    public static function storePaymentData($paymentData)
    {
        $key = \Demotic\Lib\Random::string(32);
        //loop till we get a unique key
        while(ipStorage()->get('Ecommerce', 'payment_' . $key)) {
            $key = \Demotic\Lib\Random::string(32);
        }

        $info = array(
            'data' => $paymentData,
            'time' => time()
        );

        ipStorage()->set('Ecommerce', 'payment_' . $key, $info);
        return $key;
    }

    public static function getPaymentData($key)
    {
        return ipStorage()->get('Ecommerce', 'payment_' . $key);
    }

}
