<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


namespace Demotic\Gebtu\Dispatcher;

/**
 * Filter dispatcher class
 *
 */
class FilterDispatcher extends EventListener
{
    /**
     * Trigger an event
     *
     * @param string $eventName Event name
     * @param mixed $value Data for filtering
     * @param array $data Data for event processing
     * @return null
     */
    public function filter($eventName, $value, $data = [])
    {
        if (empty($this->listeners[$eventName])) {
            return $value;
        }

        if (!isset($this->sortedListeners[$eventName])) {
            ksort($this->listeners[$eventName]);
            $this->sortedListeners[$eventName] = true;
        }

        reset($this->listeners[$eventName]);
        do {
            foreach (current($this->listeners[$eventName]) as $callable) {
                $value = call_user_func($callable, $value, $data);
            }
        } while (next($this->listeners[$eventName]) !== false);

        return $value;
    }
}
