$(document).ready(function () {
    "use strict";
    ipManagementMode.init();
});
var ipManagementMode = new (function () {
    "use strict";
    this.init = function () {
        $(document).on("ipAdminPanelInit", function () {
            $(".ipsContentEdit").on("click", function () {
                ipManagementMode.setManagementMode(1);
            });
        });
        if ("undefined" !== typeof ipWidgetSnippets) {
            $.each(ipWidgetSnippets, function (index, value) {
                $("body").append(value);
            });
        }
        if (typeof ipWidgetLayoutModalTemplate !== "undefined") {
            $("body").append(ipWidgetLayoutModalTemplate);
        }
        if (typeof ipBrowseLinkModalTemplate !== "undefined") {
            $("body").append(ipBrowseLinkModalTemplate);
        }
    };
    this.setManagementMode = function (mode) {
        $.ajax({
            url: ip.baseUrl,
            dataType: "json",
            type: "POST",
            data: { aa: "Content.setManagementMode", value: mode, securityToken: ip.securityToken },
            success: function (response) {
                if (response) {
                    var newLocation = window.location.href.split("#")[0].split("?")[0];
                    if (mode == 0 || getParameterByName("_revision")) {
                        newLocation = newLocation + "?_revision=" + ip.revisionId;
                    }
                    window.location = newLocation;
                } else {
                    window.location = ip.baseUrl + "admin";
                }
            },
            error: function (response) {
                alert("error: " + response);
            },
        });
    };
    var getParameterByName = function (name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    };
})();
function ipBrowseLink(callback) {
    var selectedPageId = null;
    var $modal = $("#ipBrowseLinkModal"),
        $iframe = $modal.find(".ipsPageSelectIframe");
    $iframe.attr("src", $iframe.data("source"));
    $modal.modal();
    var $iframeContent = $iframe.contents();
    $modal.find(".ipsConfirm").on("click", function () {
        var iframeWindow = $iframe.get(0).contentWindow;
        selectedPageId = iframeWindow.angular.element(iframeWindow.$(".ipAdminPages")).scope().selectedPageId;
        $modal.modal("hide");
    });
    $modal.off("hide.bs.modal").on("hide.bs.modal", function () {
        if (!selectedPageId) {
            callback("");
            return;
        }
        $.ajax({
            type: "GET",
            url: ip.baseUrl,
            data: { aa: "Pages.getPageUrl", pageId: selectedPageId },
            dataType: "json",
            success: function (response) {
                callback(response.pageUrl);
            },
            error: function (response) {
                if (ip.developmentEnvironment || ip.debugMode) {
                    alert("Server response: " + response.responseText);
                }
                callback("");
            },
        });
    });
}
function ipBrowseFile(callback, options) {
    if (typeof options === "undefined") {
        options = {};
    }
    var repository = new ipRepository(options);
    repository.bind("ipRepository.filesSelected", function (event, files) {
        if (callback) {
            callback(files);
        }
    });
}
var validatorConfigAdmin = "";
(function ($) {
    "use strict";
    var createConfig = function (translationsKey) {
        var config = {
            lang: ip.languageCode,
            messageClass: "hidden",
            onFail: function (e, errors) {
                $.each(errors, function () {
                    var err = this;
                    var $control = this.input;
                    $control.parents(".form-group").addClass("has-error").find(".help-error").html(this.messages.join(" "));
                    if (this.messages.join("") == "") {
                        $control.parents(".form-group").find(".help-error").hide();
                    } else {
                        $control.parents(".form-group").find(".help-error").show();
                    }
                });
                if (!isScrolledIntoView(errors[0].input) && !$(errors[0].input).hasClass("ipsDisableAutoscrollOnError")) {
                    $("html, body").animate({ scrollTop: Math.max($(errors[0].input).offset().top - 70, 0) }, 300);
                }
                $(e.target).trigger("ipOnFail", [e, errors]);
            },
            onSuccess: function (e, valids) {
                $.each(valids, function () {
                    var $control = $(this);
                    $control.parents(".form-group").removeClass("has-error");
                });
            },
        };
        return config;
    };
    var isScrolledIntoView = function (elem) {
        var docViewTop = $(window).scrollTop();
        var docViewBottom = docViewTop + $(window).height();
        var elemTop = $(elem).offset().top;
        var elemBottom = elemTop + $(elem).height();
        return elemBottom <= docViewBottom && elemTop >= docViewTop;
    };
    $.each(ipValidatorTranslations, function (key, value) {
        if (validatorConfigAdmin === "") {
            validatorConfigAdmin = createConfig(key);
        }
        $.tools.validator.localize(key, value);
    });
})(jQuery);