<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Core;


/**
 * class to output current breadcrumb
 * @package ImpressPages
 */
class Slot
{
    public static function breadcrumb_80($params)
    {
        $showHome = isset($params['showHome']) ? $params['showHome'] : true;
        return \Demotic\Gebtu\Breadcrumb\Service::generateBreadcrumb($showHome);
    }

    /**
     * @desc Generate language selection menu
     * @author Allan Laal <allan@permanent.ee>
     * @param array $params
     * @return string
     */
    public static function languages_80($params)
    {
        $data = array(
            'languages' => ipContent()->getLanguages()
        );

        if (!is_array($params)) {
            $params = [];
        }

        $data += $params;

        if (empty($data['attributes']) || !is_array($data['attributes'])) {
            $data['attributes'] = [];
        }

        $data['attributesStr'] = join(
            ' ',
            array_map(
                function ($sKey) use ($data) {
                    if (is_bool($data['attributes'][$sKey])) {
                        return $data['attributes'][$sKey] ? $sKey : '';
                    }
                    return $sKey . '="' . $data['attributes'][$sKey] . '"';
                },
                array_keys($data['attributes'])
            )
        );


        return ipView('Demotic/Gebtu/Config/view/languages.php', $data);
    }

    public static function logo_80()
    {
        $inlineManagementService = new \Demotic\Gebtu\InlineManagement\Service();
        return $inlineManagementService->generateManagedLogo();
    }


    /**
     * @desc Generate menu with custom ul ID and class
     * @author Allan Laal <allan@permanent.ee>
     * @param array $params
     * @return string
     */
    public static function menu_80($params)
    {
        $data = array(
            'items' => null,
            'depth' => 1,
            'active' => 'active',
            'crumb' => 'crumb',
            'disabled' => 'disabled',
            'parent' => 'parent',
            'children' => 'children',
            'view' => 'Demotic/Gebtu/Config/view/menu.php'
        );

        if (is_string($params)) {
            $params = array(
                'items' => $params,
            );
        }

        if (!empty($params[0]) && is_object($params[0]) && $params[0] instanceof \Demotic\Menu\Item) {
            $params = array(
                'items' => $params
            );
        }

        $data = array_merge($data, $params); // pass params to View along with other data

        if (isset($params['items']) && is_string($params['items'])) {
            $data['items'] = \Demotic\Menu\Helper::getMenuItems($params['items']);
        }
        if (empty($data['attributes']) || !is_array($data['attributes'])) {
            $data['attributes'] = [];
        }

        //generate attributes str
        if (empty($data['attributes']['class'])) {
            $data['attributes']['class'] = '';
        }
        $data['attributes']['class'] = 'level' . $data['depth'] . ' ' . $data['attributes']['class'];
        $data['attributesStr'] = join(
            ' ',
            array_map(
                function ($sKey) use ($data) {
                    if (is_bool($data['attributes'][$sKey])) {
                        return $data['attributes'][$sKey] ? $sKey : '';
                    }
                    return $sKey . '="' . $data['attributes'][$sKey] . '"';
                },
                array_keys($data['attributes'])
            )
        );

        $view = ipView($data['view'], $data);
        return $view->render();
    }


    public static function text_80($params)
    {
        $tag = 'div';
        $defaultValue = '';
        $cssClass = '';
        $attributes = null;
        $attributesStr = '';
        if (empty($params['id'])) {
            throw new \Demotic\Exception("Demotic.text slot requires parameter 'id'");
        }
        $key = $params['id'];

        if (isset($params['tag'])) {
            $tag = $params['tag'];
        }

        if (isset($params['default'])) {
            $defaultValue = $params['default'];
        }

        if (isset($params['class'])) {
            $cssClass = $params['class'];
        }

        if (isset($params['attributes'])) {
            $attributes = $params['attributes'];
        }

        $inlineManagementService = new \Demotic\Gebtu\InlineManagement\Service();
        return $inlineManagementService->generateManagedText($key, $tag, $defaultValue, $cssClass, $attributes);
    }


    public static function image_80($params)
    {
        $options = [];
        $defaultValue = '';
        $cssClass = '';
        if (empty($params['id'])) {
            throw new \Demotic\Exception("Demotic.image slot requires parameter 'id'");
        }
        $key = $params['id'];

        if (isset($params['default'])) {
            $defaultValue = $params['default'];
        }

        if (isset($params['width'])) {
            $options['width'] = $params['width'];
        }
        if (isset($params['height'])) {
            $options['height'] = $params['height'];
        }

        if (isset($params['class'])) {
            $cssClass = $params['class'];
        }

        $inlineManagementService = new \Demotic\Gebtu\InlineManagement\Service();
        return $inlineManagementService->generateManagedImage($key, $defaultValue, $options, $cssClass);
    }
}
