<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */


namespace Demotic\Gebtu\Core;


class PublicController extends \Demotic\Controller
{
    /**
     * Dummy function used to preserve user session
     */
    public function ping()
    {
        return new \Demotic\Response\Json(array(1));
    }

    public function pageNotFound()
    {
        $content = null;
        $error404Page = ipContent()->getPageByAlias('error404');
        if ($error404Page) {
            $revision = \Demotic\Gebtu\Revision::getPublishedRevision($error404Page->getId());
            $content = \Demotic\Gebtu\Content\Model::generateBlock('main', $revision['revisionId'], 0, 0);
        }
        return new \Demotic\Response\PageNotFound($content);
    }
}
