<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Content\Widget\Heading;

class Controller extends \Demotic\WidgetController
{

    public function getTitle()
    {
        return __('Heading', 'Demotic-admin', false);
    }


    public function getActionButtons()
    {
        return array(
            array(
                'label' => __('H1', 'Demotic-admin'),
                'class' => 'ipsH1'
            ),
            array(
                'label' => __('H2', 'Demotic-admin'),
                'class' => 'ipsH2'
            ),
            array(
                'label' => __('H3', 'Demotic-admin'),
                'class' => 'ipsH3'
            ),
            array(
                'label' => __('H4', 'Demotic-admin'),
                'class' => 'ipsH4'
            ),
            array(
                'label' => __('H5', 'Demotic-admin'),
                'class' => 'ipsH5'
            ),
            array(
                'label' => __('H6', 'Demotic-admin'),
                'class' => 'ipsH6'
            ),
            array(
                'label' => __('Options', 'Demotic-admin'),
                'class' => 'ipsOptions'
            )
        );
    }

    public function adminHtmlSnippet()
    {
        $maxLevel = (int) ipGetOption('Content.widgetHeadingMaxLevel', 6);
        if ($maxLevel > 6) {
            $maxLevel = 6;
        }
        if ($maxLevel < 1) {
            $maxLevel = 1;
        }
        $variables = array(
            'optionsForm' => $this->optionsForm(),
        );
        $variables2 = array(
            'maxLevel' => $maxLevel
        );
        return ipView('snippet/options.php', $variables)->render() . "\n" . ipView('snippet/controls.php', $variables2)->render();
    }

    public function generateHtml($revisionId, $widgetId, $data, $skin)
    {
        $data['showLink'] = false;
        if (!empty($data['link'])) {
            if (!preg_match('/^((http|https):\/\/)/i', $data['link'])) {
                $data['link'] = 'http://' . $data['link'];
            }

            // hiding link in administration
            if (!ipIsManagementState()) {
                $data['showLink'] = true;
            }
        }

        if (empty($data['level']) || (int)$data['level'] < 1) {
            $data['level'] = 1;
        }

        return parent::generateHtml($revisionId, $widgetId, $data, $skin);
    }

    protected function optionsForm()
    {
        $curUrl = \Demotic\Gebtu\UrlHelper::getCurrentUrl();

        $form = new \Demotic\Form();
        $form->setEnvironment(\Demotic\Form::ENVIRONMENT_ADMIN);


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'anchor',
                'label' => __('Anchor', 'Demotic-admin', false),
                'note' => __('Anchor', 'Demotic-admin') . ' <span class="ipsAnchorPreview">' . $curUrl . '#</span>'
            ));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Url(
            array(
                'name' => 'link',
                'label' => __('Link', 'Demotic-admin', false),
            ));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'blank',
                'label' => __('Open in new window', 'Demotic-admin', false),
            ));
        $form->addField($field);


        return $form; // Output a string with generated HTML form
    }

}
