<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
namespace Demotic\Gebtu\Content;


class SiteController extends \Demotic\Controller
{


    public function widgetPost()
    {
        $widgetId = ipRequest()->getPost('widgetId');

        if (!$widgetId) {
            return \Demotic\Response\JsonRpc::error('Missing widgetId POST variable');
        }
        $widgetId = $_POST['widgetId'];

        $widgetRecord = Model::getWidgetRecord($widgetId);

        try {
            if (!$widgetRecord) {
                return \Demotic\Response\JsonRpc::error(
                    "Can't find requested Widget: " . $widgetId,
                    10
                );
            }

            $widgetObject = Model::getWidgetObject($widgetRecord['name']);
            if (!$widgetObject) {
                return \Demotic\Response\JsonRpc::error(
                    "Can't find requested Widget: " . $widgetRecord['name'],
                    20
                );
            }

            return $widgetObject->post($widgetId, $widgetRecord['data']);
        } catch (\Demotic\Exception\Content $e) {
            return \Demotic\Response\JsonRpc::error($e->getMessage());
        }
    }

}
