<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
namespace Demotic\Gebtu\Content;


class Service
{


    /**
     * @return \Demotic\WidgetController[]
     */
    public static function getAvailableWidgets()
    {
        return Model::getAvailableWidgetObjects();
    }


    public static function setManagementMode($newMode)
    {
        $_SESSION['Content']['managementMode'] = $newMode ? 1 : 0;
    }

    public static function isManagementMode()
    {
        $backendLoggedIn = \Demotic\Gebtu\Admin\Backend::loggedIn();
        return $backendLoggedIn && !empty($_SESSION['Content']['managementMode']) && ipAdminPermission('Content') && !ipRequest()->getQuery('disableManagement'); //we can't check here if we are in a page. It will result in widget rendering in non management mode when widget is rendered using ajax
    }


    public static function createWidget(
        $widgetName,
        $data,
        $skin,
        $revisionId,
        $languageId,
        $blockName,
        $position,
        $visible = true
    ) {
        $widgetObject = Model::getWidgetObject($widgetName);
        if (!$widgetObject) {
            throw new \Demotic\Exception("Widget '" . esc($widgetName) . "' doesn't exist");
        }

        if ($data === null) {
            $data = $widgetObject->defaultData();
        }

        if ($skin === null) {
            $skins = $widgetObject->getSkins();
            $skin = $skins[0]['name'];
        }

        $widgetId = Model::createWidget(
            $widgetName,
            $data,
            $skin,
            $revisionId,
            $languageId,
            $blockName,
            $position,
            $visible
        );
        return $widgetId;
    }


    public static function deleteWidget($widgetId)
    {
        Model::deleteWidget($widgetId);
    }


    public static function moveWidget($widgetId, $position, $blockName, $revisionId, $languageId)
    {
        Model::moveWidget($widgetId, $position, $blockName, $revisionId, $languageId);
    }

    public static function removeRevision($revisionId)
    {
        Model::removeRevision($revisionId);
    }


    public static function getWidget($widgetId)
    {
        return Model::getWidgetRecord($widgetId);
    }

    public static function removeWidget($widgetId)
    {
        Model::removeWidget($widgetId);
    }

}
