<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Content;


class Job
{
    /**
     * @param $info
     * @return array|null
     * @throws \Demotic\Exception
     */
    public static function ipRouteAction_80($info)
    {
        if ($info['routeLanguage'] == null) {
            return null;
        }

        if ($info['relativeUri'] == '') {
            $pageId = ipContent()->getDefaultPageId();
            $page = \Demotic\Gebtu\Pages\Service::getPage($pageId);
        } else {
            $languageCode = ipContent()->getCurrentLanguage()->getCode();
            $page = \Demotic\Gebtu\Pages\Service::getPageByUrl($languageCode, $info['relativeUri']);
        }

        if (!$page || $page['isSecured'] && !ipAdminId()) {
            return null;
        }

        $result['page'] = new \Demotic\Page($page);
        $result['plugin'] = 'Content';
        $result['controller'] = 'PublicController';
        $result['action'] = 'index';
        $result['urlParts'] = isset($urlParts[1]) ? explode('/', $urlParts[1]) : [];

        return $result;
    }

    /**
     * @param $info
     * @return \Demotic\Response\Redirect
     */
    public static function ipExecuteController($info)
    {
        $page = ipContent()->getCurrentPage();
        if ($page && $page->getRedirectUrl() && !ipAdminId()) {
            return new \Demotic\Response\Redirect($page->getRedirectUrl());
        }
        return null;
    }

    /**
     * @return mixed
     */
    public static function ipDefaultPageId_70($info)
    {
        $languageCode = $info['languageCode'];
        $defaultPageId = ipGetOption('Config.defaultPageId_' . $languageCode, null);

        if ($defaultPageId) {
            return $defaultPageId;
        }


        $menus = \Demotic\Gebtu\Pages\Service::getMenus($languageCode);


        foreach ($menus as $menu) {
            $pages = \Demotic\Gebtu\Pages\Service::getChildren($menu['id'], 0, 1);
            if (!empty($pages[0]['id'])) {
                return $pages[0]['id'];
            }
        }

        return null;
    }
}
