<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Content;


/**
 *
 * Event dispatcher class
 *
 */
class Helper
{

    /**
     * @param $data
     * @return \Demotic\Language
     */
    public static function createLanguage($data)
    {
        $language = new \Demotic\Language($data['id'], $data['code'], $data['url'], $data['title'], $data['abbreviation'], $data['isVisible'], $data['textDirection']);
        return $language;
    }

    public static function initManagement()
    {
        $widgets = Service::getAvailableWidgets();
        $snippets = [];
        foreach ($widgets as $widget) {
            $snippetHtml = $widget->adminHtmlSnippet();
            if ($snippetHtml != '') {
                $snippets[] = $snippetHtml;
            }
        }
        ipAddJsVariable('ipWidgetSnippets', $snippets);


        ipAddJsVariable('ipContentInit', Model::initManagementData());



        ipAddJs('Demotic/Gebtu/Core/assets/js/jquery-ui/jquery-ui.js');
        ipAddCss('Demotic/Gebtu/Core/assets/js/jquery-ui/jquery-ui.css');

        if (ipConfig()->isDebugMode()) {
            ipAddJs('Demotic/Gebtu/Content/assets/management/ipContentManagementInit.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/content.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/jquery.ip.contentManagement.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/jquery.ip.widgetbutton.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/jquery.ip.layoutModal.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/jquery.ip.block.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/jquery.ip.widget.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/exampleContent.js');
            ipAddJs('Demotic/Gebtu/Content/assets/management/drag.js');

            ipAddJs('Demotic/Gebtu/Content/Widget/Columns/assets/Columns.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/File/assets/File.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/File/assets/jquery.ipWidgetFile.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/File/assets/jquery.ipWidgetFileContainer.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Form/assets/Form.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Form/assets/FormContainer.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Form/assets/FormField.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Form/assets/FormOptions.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Html/assets/Html.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Video/assets/Video.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Image/assets/Image.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Gallery/assets/Gallery.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Text/assets/Text.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Heading/assets/Heading.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Heading/assets/HeadingModal.js');
            ipAddJs('Demotic/Gebtu/Content/Widget/Map/assets/Map.js');

        } else {
            ipAddJs('Demotic/Gebtu/Content/assets/management.min.js');
        }



        ipAddJs('Demotic/Gebtu/Core/assets/js/jquery-tools/jquery.tools.ui.scrollable.js');


        ipAddJs('Demotic/Gebtu/Content/assets/jquery.ip.uploadImage.js');

        ipAddJsVariable('isMobile', \Demotic\Gebtu\Browser::isMobile());


        ipAddJsVariable(
            'ipWidgetLayoutModalTemplate',
            ipView('view/widgetLayoutModal.php')->render()
        );

    }
}
