<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Content;


class Event
{
    protected static function addWidgetAssets(\Demotic\WidgetController $widget)
    {
        $pluginAssetsPath = $widget->getWidgetDir() . \Demotic\Application::ASSETS_DIR . '/';
        static::includeResources($pluginAssetsPath);
    }

    private static function includeResources($resourcesFolder)
    {

        if (is_dir(ipFile($resourcesFolder))) {
            $files = scandir(ipFile($resourcesFolder));
            if ($files === false) {
                return;
            }


            foreach ($files as $file) {
                if (is_dir(ipFile($resourcesFolder . $file)) && $file != '.' && $file != '..') {
                    static::includeResources(ipFile($resourcesFolder . $file));
                    continue;
                }
                if (strtolower(substr($file, -3)) == '.js') {
                    ipAddJs($resourcesFolder . $file);
                }
                if (strtolower(substr($file, -4)) == '.css') {
                    ipAddCss($resourcesFolder . $file);
                }
            }
        }
    }

    public static function ipBeforeController()
    {
        $ipUrlOverrides = ipConfig()->get('urlOverrides');
        if (!$ipUrlOverrides) {
            $ipUrlOverrides = [];
        }

        ipAddJsVariable('ipUrlOverrides', $ipUrlOverrides);

        // Add widgets
        //TODO cache found assets to decrease file system usage
        $widgets = Service::getAvailableWidgets();

        if (ipIsManagementState()) {
            foreach ($widgets as $widget) {
                if (!$widget->isCore()) { //core widget assets are included automatically in one minified file
                    static::addWidgetAssets($widget);
                }
            }
            ipAddJsVariable('ipPublishTranslation', __('Publish', 'Demotic-admin', false));
        }
    }

    /**
     * Used when management is needed in controller routed using routes.
     * @param $info
     * @return null
     */
    public static function ipBeforeController_70($info)
    {
        if (empty($info['page']) || empty($info['management']) || !ipIsManagementState()) {
            return null;
        }

        //find current page
        $page = $info['page'];

        // change layout if safe mode
        if (\Demotic\Gebtu\Admin\Service::isSafeMode()) {
            ipSetLayout(ipFile('Demotic/Gebtu/Admin/view/safeModeLayout.php'));
        } else {
            ipSetLayout($page->getLayout());
        }

        // initialize management
        if (!ipRequest()->getQuery('ipDesignPreview') && !ipRequest()->getQuery('disableManagement')) {
            Helper::initManagement();
        }

        //show page content
        $response = ipResponse();
        $response->setDescription(\Demotic\ServiceLocator::content()->getDescription());
        $response->setKeywords(ipContent()->getKeywords());
        $response->setTitle(ipContent()->getTitle());
    }

    public static function ipAdminLoginSuccessful($info)
    {
        Service::setManagementMode(1);
    }


    public static function ipPageRevisionDuplicated($info)
    {
        Model::duplicateRevision($info['basedOn'], $info['newRevisionId']);
    }

    public static function ipPageRemoved($info)
    {
        Model::removePageRevisions($info['pageId']);
    }

    public static function ipUrlChanged($info)
    {
        $httpExpression = '/^((http|https):\/\/)/i';
        if (!preg_match($httpExpression, $info['oldUrl'])) {
            return;
        }
        if (!preg_match($httpExpression, $info['newUrl'])) {
            return;
        }
        Model::updateUrl($info['oldUrl'], $info['newUrl']);
    }





    public static function ipCronExecute($info)
    {
        if ($info['firstTimeThisDay'] || $info['test']) {
            if (ipGetOption('Config.removeOldRevisions', 0)) {
                \Demotic\Gebtu\Revision::removeOldRevisions(ipGetOption('Config.removeOldRevisionsDays', 720));
            }
        }
    }

}
