<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Config;


class Forms
{
    public static function getForm()
    {
        $form = new \Demotic\Form();
        $form->addClass('ipsConfigForm');
        $form->setAjaxSubmit(0);


        $field = new FieldOptionTextLang(
            array(
                'optionName' => 'Config.websiteTitle',
                'name' => 'websiteTitle', //html "name" attribute
                'label' => __('Website title', 'Demotic-admin', false), //field label that will be displayed next to input field
                'hint' => __('Used as a sender name in emails and as default website logo.', 'Demotic-admin')
            ));
        $field->addClass('ipsAutoSave');
        $form->addField($field);


        $field = new FieldOptionTextLang(
            array(
                'optionName' => 'Config.websiteEmail',
                'name' => 'websiteEmail', //html "name" attribute
                'value' => ipGetOptionLang('Config.websiteEmail'),
                'label' => __('Website email', 'Demotic-admin', false), //field label that will be displayed next to input field
                'hint' => __('Email address used as a sender to send emails on behalf of the website.', 'Demotic-admin')
            ));
        $field->addValidator('Email');
        $field->addClass('ipsAutoSave');
        $form->addField($field);


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'gmapsApiKey',
                'value' => ipGetOption('Config.gmapsApiKey'),
                'label' => __('Google Maps API key', 'Demotic-admin', false),
                'note' => __('You must provide Google Maps API key for Map widget to work.', 'Demotic-admin', false) . ' <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">' . __('Follow instructions.', 'Demotic-admin', false) . '</a>'
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);

        return $form;
    }


    public static function getAdvancedForm()
    {
        $form = new \Demotic\Form();
        $form->addClass('ipsConfigForm');
        $form->addClass('ipsConfigFormAdvanced');
        $form->setAjaxSubmit(0);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'automaticCron',
                //html "name" attribute
                'value' => ipGetOption('Config.automaticCron', 1),
                'label' => __('Execute cron automatically', 'Demotic-admin', false),
                //field label that will be displayed next to input field
                'hint' => __(
                    'Demotic CMS executes cron once an hour on any randomly selected visitor page load. If you have setup cron manually, you can disable automatic cron functionality.',
                    'Demotic-admin'
                ),
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);

        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'cronPassword', //html "name" attribute
                'value' => ipGetOption('Config.cronPassword', 1),
                'label' => __('Cron password', 'Demotic-admin', false), //field label that will be displayed next to input field
                'hint' => __('Protect cron from being abusively executed by the strangers.', 'Demotic-admin', false),
                'note' => '<span class="ipsUrlLabel">' . __(
                        'Cron URL: ',
                        'Demotic-admin'
                    ) . '</span><a target="_blank" class="ipsUrl"></a>'
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);




        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'removeOldEmails',
                //html "name" attribute
                'value' => ipGetOption('Config.removeOldEmails', 0),
                'label' => __('Remove old emails from the log', 'Demotic-admin', false)
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);




        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'removeOldEmailsDays',
                //html "name" attribute
                'value' => ipGetOption('Config.removeOldEmailsDays', 720),
                'label' => __('Days to keep emails', 'Demotic-admin', false),
                'hint' => __('Meaningful only if "Remove old emails" is on.', 'Demotic-admin', false)
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'removeOldRevisions',
                //html "name" attribute
                'value' => ipGetOption('Config.removeOldRevisions', 0),
                'label' => __('Remove old page revisions', 'Demotic-admin', false)
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);




        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'removeOldRevisionsDays',
                //html "name" attribute
                'value' => ipGetOption('Config.removeOldRevisionsDays', 720),
                'label' => __('Days to keep revisions', 'Demotic-admin', false),
                'hint' => __('Meaningful only if "Remove old page revisions" is on.', 'Demotic-admin', false)
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'allowAnonymousUploads',
                //html "name" attribute
                'value' => ipGetOption('Config.allowAnonymousUploads', 1),
                'label' => __('Allow anonymous uploads', 'Demotic-admin', false),
                'hint' => __('Disabling this feature will prevent users from uploading files to your website. E.g. in contact forms.', 'Demotic-admin')
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);



        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'trailingSlash',
                //html "name" attribute
                'value' => ipGetOption('Config.trailingSlash', 1),
                'label' => __('Add trailing slash at the end of page URL', 'Demotic-admin', false),
                'hint' => __('This won\'t change existing URLs. Only new and updated pages will get slash at the end.', 'Demotic-admin')
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);


        return $form;
    }

    public static function getMaintenanceForm()
    {
        $form = new \Demotic\Form();
        $form->addClass('ipsConfigForm');
        $form->addClass('ipsConfigFormMaintenance');
        $form->setAjaxSubmit(0);


        $field = new \Demotic\Form\Field\Checkbox(
            array(
                'name' => 'maintenanceModeActive',
                'value' => ipGetOption('Config.maintenanceModeActive', 0),
                'label' => __('Check this box to set your site under maintenance mode. Uncheck to leave maintenance mode.', 'Demotic-admin', false),
                'hint' => __('Place your site under maintenance mode if you are doing some heavy updates. You can still log into the site using the URI set in your "config.php" file', 'Demotic-admin')
            ));
        $field->addClass('ipsAutoSave');
        $field->addAttribute('data-fieldid', $field->getName());
        $field->addAttribute('id', $field->getName());
        $field->addAttribute('data-fieldname', $field->getName());
        $form->addField($field);

        return $form;
    }
}
