<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Config;


class AdminController extends \Demotic\Controller
{

    /**
     * @ipSubmenu General
     * @return string
     */
    public function index()
    {


        ipAddJs('Demotic/Gebtu/Config/assets/config.js');
        ipAddCss('Demotic/Gebtu/Config/assets/config.css');

        $form = Forms::getForm();
        $data = array(
            'form' => $form
        );
        return ipView('view/configWindow.php', $data)->render();

    }

    /**
     * @ipSubmenu Advanced
     * @return string
     */
    public function advanced()
    {


        ipAddJs('Demotic/Gebtu/Config/assets/config.js');
        ipAddCss('Demotic/Gebtu/Config/assets/config.css');

        $advancedForm = false;
        if (ipAdminPermission('Config advanced')) {
            $advancedForm = Forms::getAdvancedForm();
        }
        $data = array(
            'advancedForm' => $advancedForm
        );
        return ipView('view/configCron.php', $data)->render();

    }

    /**
     * @ipSubmenu Maintenance
     * @return string
     */
    public function maintenance()
    {
        ipAddJs('Demotic/Gebtu/Config/assets/config.js');
        ipAddCss('Demotic/Gebtu/Config/assets/config.css');

        $form = Forms::getMaintenanceForm();
        $data = array(
            'form' => $form,
        );
        return ipView('view/configMaintenanceWindow.php', $data)->render();

    }


    public function saveValue()
    {
        $request = \Demotic\ServiceLocator::request();

        $request->mustBePost();

        $post = $request->getPost();
        if (empty($post['fieldName'])) {
            throw new \Exception('Missing required parameter');
        }
        $fieldName = $post['fieldName'];
        if (!isset($post['value'])) {
            throw new \Exception('Missing required parameter');
        }
        $value = $post['value'];

        if (
            !in_array($fieldName, array('websiteTitle', 'websiteEmail', 'gmapsApiKey'))
            &&
            !(
                in_array($fieldName, array('automaticCron', 'cronPassword', 'removeOldRevisions', 'removeOldRevisionsDays', 'removeOldEmails', 'removeOldEmailsDays', 'allowAnonymousUploads', 'trailingSlash', 'maintenanceModeActive'))
                &&
                ipAdminPermission('Config advanced')
            )
        ) {
            throw new \Exception('Unknown config value');
        }




        $emailValidator = new \Demotic\Form\Validator\Email();
        $error = $emailValidator->getError(array('value' => $value), 'value', \Demotic\Form::ENVIRONMENT_ADMIN);
        if ($fieldName === 'websiteEmail' && $error !== false) {
            return $this->returnError($error);
        }


        if (in_array($fieldName, array('websiteTitle', 'websiteEmail'))) {
            if (!isset($post['languageId'])) {
                throw new \Exception('Missing required parameter');
            }
            $languageId = $post['languageId'];
            $language = ipContent()->getLanguage($languageId);
            ipSetOptionLang('Config.' . $fieldName, $value, $language->getCode());
        } else {
            ipSetOption('Config.' . $fieldName, $value);
        }


        return new \Demotic\Response\Json(array(1));

    }

    private function returnError($errorMessage)
    {
        $data = array(
            'error' => $errorMessage
        );
        return new \Demotic\Response\Json($data);
    }
}
