<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu;


/**
 * Class to detect browser capabilities
 * @package Demotic
 */
class Browser
{
    public static function isMobile()
    {
        if (defined('IS_MOBILE')) {
            return (bool)IS_MOBILE;
        }

        if (isset($_SESSION['lib']['browser']['isMobile'])) {
            return (bool)$_SESSION['lib']['browser']['isMobile'];
        }
        $detect = new \Demotic\Lib\MobileDetect();
        $isMobile = $detect->isMobile();
        $_SESSION['lib']['browser']['isMobile'] = $isMobile;
        return $isMobile;
    }


    public static function getLanguages()
    {
        $answer = Array();
        if (isset($_SERVER["HTTP_ACCEPT_LANGUAGE"])) {
            $lang_list = explode(",", $_SERVER["HTTP_ACCEPT_LANGUAGE"]);
            for ($i = 0; $i < count($lang_list); $i++) {
                if (strpos($lang_list[$i], ";") === false) {
                    $answer[] = $lang_list[$i];
                } else {
                    $tmp_array = explode(";", $lang_list[$i]);
                    $answer[] = $tmp_array[0];
                }
            }
        }
        return $answer;
    }
}