<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Administrators;


class Helper
{
    public static function createForm()
    {
        $form = new \Demotic\Form();
        $form->addAttribute('autocomplete', 'off');


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'username', // HTML "name" attribute
                'label' => __('User name', 'Demotic-admin', false), // Field label that will be displayed next to input field
            ));
        $field->addValidator("Required");
        $field->addValidator(array('Unique', array('table' => 'administrator')));
        $form->addField($field);


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'email', // HTML "name" attribute
                'label' => __('Email', 'Demotic-admin', false), // Field label that will be displayed next to input field
            ));
        $field->addValidator("Required");
        $form->addField($field);

        $field = new \Demotic\Form\Field\Password(
            array(
                'name' => 'password', // HTML "name" attribute
                'label' => __('Password', 'Demotic-admin', false), // Field label that will be displayed next to input field
            ));
        $field->addValidator("Required");
        $form->addField($field);

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'aa', // HTML "name" attribute
                'value' => 'Administrators.add'
            ));
        $form->addField($field);

        return $form;
    }


    public static function updateForm()
    {
        $form = new \Demotic\Form();
        $form->addAttribute('autocomplete', 'off');


        $field = new \Demotic\Form\Field\Text(
            array(
                'name' => 'username', // HTML "name" attribute
                'label' => __('User name', 'Demotic-admin', false), // Field label that will be displayed next to input field
                'value' => '{{activeAdministrator.username}}'
            ));
        $field->addValidator("Required");
        $form->addField($field);


        $field = new \Demotic\Form\Field\Email(
            array(
                'name' => 'email', // HTML "name" attribute
                'label' => __('Email', 'Demotic-admin', false), // Field label that will be displayed next to input field
                'value' => '{{activeAdministratorEmail}}'
            ));
        $field->addValidator("Required");
        $form->addField($field);

        $field = new \Demotic\Form\Field\Password(
            array(
                'name' => 'password',
                // HTML "name" attribute
                'label' => __('New password (optional)', 'Demotic-admin', false),
                // Field label that will be displayed next to input field
                'value' => ''
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'aa', // HTML "name" attribute
                'value' => 'Administrators.update'
            ));
        $form->addField($field);

        $field = new \Demotic\Form\Field\Hidden(
            array(
                'name' => 'id', // HTML "name" attribute
                'value' => ''
            ));
        $form->addField($field);

        return $form;
    }

}
