<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu;


class AdminPermissionsModel
{
    public static function getUserPermissions($administratorId = null)
    {
        if ($administratorId === null) {
            $administratorId = ipAdminId();
        }
        $permissions = ipDb()->selectColumn('permission', 'permission', array('administratorId' => $administratorId));
        if (!empty($permissions)) {
            $permissions = array_combine($permissions, $permissions);
        }

        return $permissions;
    }

    /**
     * Get list of all available permissions on the system
     */
    public static function availablePermissions()
    {
        $permissions = array(
            'Super admin',
            'Content',
            'Pages',
            'Design',
            'Plugins',
            'Config',
            'Config advanced',
            'Languages',
            'System',
            'Administrators',
            'Log',
            'Email',
            'Repository',
            'Repository upload'
        );

        $plugins = \Demotic\Gebtu\Plugins\Model::getActivePluginNames();
        foreach ($plugins as $plugin) {
            if (is_file(ipFile('Plugin/' . $plugin . '/AdminController.php'))) {
                array_push($permissions, $plugin);
            }
        }

        $permissions = ipFilter('ipAvailablePermissions', $permissions);
        return $permissions;
    }

    public static function removeUserPermissions($administratorId = null)
    {
        if ($administratorId === null) {
            $administratorId = ipAdminId();
        }
        ipDb()->delete('permission', array('administratorId' => $administratorId));
    }

    public static function addPermission($permission, $administratorId = null)
    {
        if ($administratorId === null) {
            $administratorId = ipAdminId();
        }
        $data = array(
            'permission' => $permission,
            'administratorId' => $administratorId
        );
        ipDb()->insert('permission', $data, true);
    }

    public static function removePermission($permission, $administratorId = null)
    {
        if ($administratorId === null) {
            $administratorId = ipAdminId();
        }
        $condition = array(
            'permission' => $permission,
            'administratorId' => $administratorId
        );
        ipDb()->delete('permission', $condition);
    }
}
