<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu;


class AdminPermissions
{
    protected $userId;

    protected $permissions = [];

    public function __construct()
    {
    }

    public function hasPermission($permission, $administratorId = null)
    {
        if (in_array($permission, array('InlineManagement'))) {
            $permission = 'Content';
        }

        if ($administratorId == null) {
            $administratorId = ipAdminId();
        }
        if (!isset($this->permissions[$administratorId])) {
            $this->permissions[$administratorId] = AdminPermissionsModel::getUserPermissions($administratorId);
        }

        $answer = isset($this->permissions[$administratorId][$permission]) || isset($this->permissions[$administratorId]['Super admin']);
        $answer = ipFilter(
            'ipAdminPermission',
            $answer,
            array('permission' => $permission, 'administratorId' => $administratorId)
        );

        return $answer;
    }
}
