<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Admin;


class Submenu
{

    public static function getSubmenuItems()
    {
        $submenuItems = ipFilter('ipAdminSystemSubmenu', []);

        if (!$submenuItems) {
            if (ipRoute()->controller() == 'AdminController' && class_exists(ipRoute()->controllerClass())) {
                $submenuItems = self::getControllerMenu(ipRoute()->controllerClass());
            }
        }

        return $submenuItems;
    }

    protected static function getControllerMenu($class)
    {
        $reflector = new \ReflectionClass($class);
        $methods = $reflector->getMethods();

        $submenuItems = [];
        foreach ($methods as $method)
        {
            if (in_array($method, array('index'))) {
                continue;
            }
            if (!$method->isPublic()) {
                continue;
            }
            $docComment = $method->getDocComment();
            if (preg_match_all('/@(\w+)\s+(.*)\r?\n/m', $docComment, $matches)){
                $result = array_combine($matches[1], $matches[2]);
                if (isset($result['ipSubmenu'])) {
                    $menuItem = new \Demotic\Menu\Item();
                    $menuItem->setTitle(__($result['ipSubmenu'], ipRoute()->plugin(), false));
                    $menuItem->setUrl(ipActionUrl(array('aa' => ipRoute()->plugin() . '.' . $method->getName())));
                    if (ipRoute()->action() == $method->getName()) {
                        $menuItem->markAsCurrent(true);
                    }
                    $submenuItems[] = $menuItem;
                }
            }
        }
        if (!empty($submenuItems)) {
            return $submenuItems;
        }
        return null;
    }
}
