<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
 
namespace Demotic\Gebtu\Admin;


class SecurityModel
{
    protected function __construct()
    {

    }

    /**
     * @return SecurityModel
     */
    public static function instance()
    {
        return new SecurityModel();
    }


    public function registerFailedLogin($username, $ip)
    {
        $failedLogin = array(
            'username' => $username,
            'ip' => $ip,
            'time' => time()
        );
        $failedLogins = $this->failedLogins();
        $failedLogins[] = $failedLogin;
        $this->setFailedLogins($failedLogins);
    }

    public function failedLoginCount($username, $ip)
    {
        $allFailedLogins = $this->failedLogins();

        $count = 0;
        foreach ($allFailedLogins as $login) {
            if ($login['time'] > time() - 60 * 60 && $login['username'] == $username && $login['ip'] == $ip) {
                $count++;
            }
        }

        return $count;
    }


    /**
     * @return array
     */
    private function failedLogins()
    {
        $failedLogins = ipStorage()->get('Admin', 'failedLogins', []);
        return $failedLogins;
    }

    public function cleanup()
    {
        $failedLogins = $this->failedLogins();
        $filtered = [];
        foreach ($failedLogins as $login) {
            if ($login['time'] > time() - 60 * 60) {
                $filtered[] = $login;
            }
        }
        $this->setFailedLogins($filtered);
    }

    private function setFailedLogins($failedLogins)
    {
        ipStorage()->set('Admin', 'failedLogins', $failedLogins);
    }


}
