<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */
 
namespace Demotic\Gebtu\Admin;

use Demotic\Config;


class Model
{

    protected $errors = [];

    protected function __construct()
    {

    }

    /**
     * @param \Demotic\Request $request
     * @return bool
     */
    public static function isLoginPage(\Demotic\Request $request = null)
    {
        $configLoginUrl = ipConfig()->get('loginURI');
        $possible_login_paths = array(
            'dashboard',
            'dashboard/',
            'dashboard.php',
            'dashboard.php/',
        );

        if(!empty($configLoginUrl)){
            $possible_login_paths[] = $configLoginUrl;//Add to our array for possible login paths
        }else{
            $possible_login_paths = $possible_login_paths;
        }

        if ($request == null) {
            $request = ipRequest();
        }
        $relativePath = $request->getRelativePath();
        return in_array($relativePath, $possible_login_paths);
    }

    public static function isPasswordResetPage(\Demotic\Request $request = null)
    {
        if ($request == null) {
            $request = ipRequest();
        }
        $sa = $request->getQuery('sa');
        return in_array($sa, array('Admin.passwordResetForm', 'Admin.passwordReset'));
    }

    /**
     * @return Model
     */
    public static function instance()
    {
        return new Model();
    }

    /**
     * @param string $currentModule Name of the current (active) module
     * @return \Demotic\Gebtu\Admin\MenuItem[]
     */
    public function getAdminMenuItems($currentModule)
    {
        $answer = [];


        $modules = \Demotic\Gebtu\Plugins\Model::getModules();
        foreach ($modules as $module) {

            // skipping modules that don't have 'index' (default) action in AdminController
            $controllerClass = 'Demotic\\Gebtu\\' . $module . '\\AdminController';
            if (!class_exists($controllerClass) || !method_exists($controllerClass, 'index')) {
                continue;
            }

            $moduleItem = new \Demotic\Gebtu\Admin\MenuItem();
            $moduleItem->setTitle(__($module, 'Demotic-admin', false));
            $moduleItem->setUrl(ipActionUrl(array('aa' => $module . '.index')));
            $moduleItem->setIcon($this->getAdminMenuItemIcon($module));
            if ($module == $currentModule) {
                $moduleItem->markAsCurrent(true);
            }

            if (ipAdminPermission($module)) {
                $answer[] = $moduleItem;
            }
        }


        $plugins = \Demotic\Gebtu\Plugins\Service::getActivePlugins();

        foreach ($plugins as $plugin) {
            $controllerClass = '\\Plugin\\' . $plugin['name'] . '\\AdminController';
            if (!class_exists($controllerClass) || !method_exists($controllerClass, 'index')) {
                continue;
            }
            $moduleItem = new \Demotic\Gebtu\Admin\MenuItem();
            $moduleItem->setTitle(__($plugin['title'], 'Demotic-admin', false));
            $moduleItem->setUrl(ipActionUrl(array('aa' => $plugin['name'])));
            $moduleItem->setIcon($this->getAdminMenuPluginIcon($plugin['name']));
            if ($plugin['name'] == $currentModule) {
                $moduleItem->markAsCurrent(true);
            }
            if (ipAdminPermission($plugin['name'])) {
                $answer[] = $moduleItem;
            }
        }

        $answer = ipFilter('ipAdminMenu', $answer);

        return $answer;
    }
    
    /**
     * Function to get icon from plugin config
     * @param $module
     * @return string
     */
    public static function getAdminMenuPluginIcon($module)
    {
        $conf = \Demotic\Gebtu\Plugins\Service::getPluginConfig($module);
        return isset($conf['icon']) ? $conf['icon'] : 'fa-cog';
    }

    public static function getAdminMenuItemIcon($module)
    {
        $icon = 'fa-cog'; // default

        switch ($module) {
            case 'Content':
                $icon = 'fa-pencil-square-o';
                break;
            case 'Pages':
                $icon = 'fa-sitemap';
                break;
            case 'Administrators':
                $icon = 'fa-users';
                break;
            case 'Design':
                $icon = 'fa-pencil';
                break;
            case 'Plugins':
                $icon = 'fa-code-fork';
                break;
            case 'Config':
                $icon = 'fa-cog';
                break;
            case 'Languages':
                $icon = 'fa-language';
                break;
            case 'Media':
                $icon = 'fa-image';
                break;
        }

        return $icon;
    }

    public static function setSafeMode($value)
    {
        $_SESSION['module']['admin']['safemode'] = (bool)$value;
    }

    public static function isSafeMode()
    {
        if (isset($_SESSION['module']['admin']['safemode'])) {
            return (bool)$_SESSION['module']['admin']['safemode'];
        }
        return false;
    }

    public static function getUserId()
    {
        if (isset($_SESSION['backend_session']['userId'])) {
            return $_SESSION['backend_session']['userId'];
        } else {
            return false;
        }
    }

    public function login($username, $password)
    {
        $ip = ipRequest()->getServer('REMOTE_ADDR');

        $preventReason = ipJob('ipAdminLoginPrevent', array('username' => $username));
        if ($preventReason) {
            $this->errors = array('global_error' => $preventReason);
            ipLog()->notice(
                'Admin.loginPrevented: {username} from {ip}',
                array('username' => $username, 'ip' => ipRequest()->getServer('REMOTE_ADDR'))
            );
            return false;
        }


        $administrator = \Demotic\Gebtu\Administrators\Service::getByUsername($username);
        if (!$administrator) {
            \Demotic\ServiceLocator::dispatcher()->event(
                'ipAdminLoginFailed',
                array('username' => $username, 'ip' => ipRequest()->getServer('REMOTE_ADDR'))
            );
            ipLog()->info('Admin.incorrectLogin: {username} from {ip}', array('username' => $username, 'ip' => $ip));
            $this->errors = array('login' => __('Following user doesn\'t exist', 'Demotic-admin'));
            return false;
        }

        if (\Demotic\Gebtu\Administrators\Service::checkPassword($administrator['id'], $password)) {
            Service::setAdminLogin($username);
            return true;
        } else {
            \Demotic\ServiceLocator::dispatcher()->event(
                'ipAdminLoginFailed',
                array('username' => $username, 'ip' => ipRequest()->getServer('REMOTE_ADDR'))
            );
            ipLog()->info('Admin.incorrectLogin: {username} from {ip}', array('username' => $username, 'ip' => $ip));
            $this->errors = array('password' => __('Incorrect password', 'Demotic-admin'));
            return false;
        }
    }

    public function setAdminLogin($username)
    {
        $administrator = \Demotic\Gebtu\Administrators\Service::getByUsername($username);
        $ip = ipRequest()->getServer('REMOTE_ADDR');
        Backend::login($administrator['id']);
        ipEvent('ipAdminLoginSuccessful', array('username' => $username, 'id' => $administrator['id']));
        ipLog()->info('Admin.loggedIn: {username} from {ip}', array('username' => $username, 'ip' => $ip));

    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function logout()
    {
        Backend::logout();
    }

    public static function randString($length)
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $str = '';
        $size = strlen($chars);
        for ($i = 0; $i < $length; $i++) {
            $str .= $chars[rand(0, $size - 1)];
        }

        return $str;
    }

}
