<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Admin;


class Event
{
    protected static function getAdminNavbarHtml()
    {
        $requestData = \Demotic\ServiceLocator::request()->getRequest();
        $curModTitle = '';
        $curModUrl = '';
        $curModIcon = '';

        if (!empty($requestData['aa'])) {
            $parts = explode('.', $requestData['aa']);
            $curModule = $parts[0];
        } else {
            $curModule = "Content";
        }

        if (isset($curModule) && $curModule) {
            $title = $curModule;
            $pluginConfig = \Demotic\Gebtu\Plugins\Service::getPluginConfig($curModule);
            
            $curModTitle = __($title, 'Demotic-admin', false);
            $curModUrl = ipActionUrl(array('aa' => $curModule . '.index'));
            $curModIcon = Model::getAdminMenuItemIcon($curModule);
            
            //try to translate and get icon in config.json
            $curModTitle = isset($pluginConfig['title']) ? __($pluginConfig['title'], $curModule, false) : $curModTitle;
            $curModIcon = isset($pluginConfig['icon']) ? $pluginConfig['icon'] : $curModIcon;
        }

        $navbarButtons = array(
            array(
                'text' => '',
                'hint' => __('Logout', 'Demotic-admin', false),
                'url' => ipActionUrl(array('sa' => 'Admin.logout')),
                'class' => 'ipsAdminLogout',
                'faIcon' => 'fa-power-off'
            )
        );

        $navbarButtons = ipFilter('ipAdminNavbarButtons', $navbarButtons);

        $navbarCenterElements = ipFilter('ipAdminNavbarCenterElements', []);

        $data = array(
            'menuItems' => Model::instance()->getAdminMenuItems($curModule),
            'curModTitle' => $curModTitle,
            'curModUrl' => $curModUrl,
            'curModIcon' => $curModIcon,
            'navbarButtons' => array_reverse($navbarButtons),
            'navbarCenterElements' => $navbarCenterElements
        );


        $html = ipView('view/navbar.php', $data)->render();
        return $html;
    }

    public static function ipInitFinished ()
    {
        $request = \Demotic\ServiceLocator::request();
        $safeMode = $request->getQuery('safeMode');
        if ($safeMode === null) {
            $safeMode = $request->getQuery('safemode');
        }

        if ($safeMode !== null && \Demotic\Gebtu\Admin\Backend::userId()) {
            Model::setSafeMode($safeMode);
        }
    }

    public static function ipBeforeController()
    {


        //show admin submenu if needed
        if (ipRoute()->isAdmin()) {
            ipAddJs('Demotic/Gebtu/Core/assets/js/jquery-ui/jquery-ui.js');
            ipAddCss('Demotic/Gebtu/Core/assets/js/jquery-ui/jquery-ui.css');

            $submenu = Submenu::getSubmenuItems();
            $submenu = ipFilter('ipAdminSubmenu', $submenu);
            if ($submenu) {
                ipResponse()->setLayoutVariable('submenu', $submenu);
            }
        }

        // Show admin toolbar if admin is logged in:
        if (ipAdminId() && !ipRequest()->getRequest('pa') || ipRequest()->getRequest('aa') && ipAdminId()) {
            if (!ipRequest()->getQuery('ipDesignPreview') && !ipRequest()->getQuery('disableAdminNavbar')) {
                ipAddJs('Demotic/Gebtu/Admin/assets/admin.js');
                ipAddJsVariable('ipAdminNavbar', static::getAdminNavbarHtml());
            }
        }

        // Show popup with autogenerated user information if needed and if admin is logged in
        if (ipAdminId() && !ipRequest()->getRequest('pa') || ipRequest()->getRequest('aa') && ipAdminId()) {
            $adminIsAutogenerated = ipStorage()->get('Demotic', 'adminIsAutogenerated');
            if ($adminIsAutogenerated) {
                $adminId = \Demotic\Gebtu\Admin\Backend::userId();
                $admin = \Demotic\Gebtu\Administrators\Model::getById($adminId);
                ipAddJs('Demotic/Gebtu/Admin/assets/adminIsAutogenerated.js');
                $data = array(
                    'adminUsername' => $admin['username'],
                    'adminPassword' => ipStorage()->get('Demotic', 'adminIsAutogenerated'),
                    'adminEmail' => $admin['email']
                );
                ipAddJsVariable('ipAdminIsAutogenerated', ipView('view/adminIsAutoGenerated.php', $data)->render());
            }
        }


        if (ipContent()->getCurrentPage()) {
            // initialize management
            if (ipIsManagementState()) {
                if (!ipRequest()->getQuery('ipDesignPreview') && !ipRequest()->getQuery('disableManagement')) {
                    \Demotic\Gebtu\Content\Helper::initManagement();
                }
            }

            //show page content
            $response = ipResponse();
            $response->setDescription(\Demotic\ServiceLocator::content()->getDescription());
            $response->setKeywords(ipContent()->getKeywords());
            $response->setTitle(ipContent()->getTitle());

        }


    }

    public static function ipAdminLoginFailed($data)
    {
        $securityModel = SecurityModel::instance();
        $securityModel->registerFailedLogin($data['username'], $data['ip']);
    }

    public static function ipCronExecute($data)
    {
        if ($data['firstTimeThisDay']) {
            $securityModel = SecurityModel::instance();
            $securityModel->cleanup();
        }
    }

}
