<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Admin;

/**
 *
 * Event dispatcher class
 *
 */
class Backend
{

    public static function userId()
    {
        if (isset($_SESSION['backend_session']['userId'])) {
            return $_SESSION['backend_session']['userId'];
        } else {
            return false;
        }
    }

    public static function loggedIn()
    {
        return isset($_SESSION['backend_session']['userId']) && $_SESSION['backend_session']['userId'] != null;
    }

    public static function logout()
    {
        $adminId = ipAdminId();
        ipEvent('ipBeforeAdminLogout', array('administratorId' => $adminId));
        if (isset($_SESSION['backend_session'])) {
            unset($_SESSION['backend_session']);
        }
        session_destroy();
        ipEvent('ipAdminLoggedOut', array('administratorId' => $adminId));
    }

    public static function login($id)
    {
        $_SESSION['backend_session']['userId'] = $id;
        session_regenerate_id(true);
        ipEvent('ipAdminLoggedIn', array('administratorId' => $id));
    }

}
