<?php
/*
*

 ______   _______  __   __  _______  _______  ___   _______ 
|      | |       ||  |_|  ||       ||       ||   | |       |
|  _    ||    ___||       ||   _   ||_     _||   | |       |
| | |   ||   |___ |       ||  | |  |  |   |  |   | |       |
| |_|   ||    ___||       ||  |_|  |  |   |  |   | |      _|
|       ||   |___ | ||_|| ||       |  |   |  |   | |     |_ 
|______| |_______||_|   |_||_______|  |___|  |___| |_______|
 _______  __   __  _______                                  
|       ||  |_|  ||       |                                 
|       ||       ||  _____|                                 
|       ||       || |_____                                  
|      _||       ||_____  |                                 
|     |_ | ||_|| | _____| |                                 
|_______||_|   |_||_______|                                                   
                                              
                                           
*
*
*/

/**
 * Demotic CMS is a fork of ImpressPages.
 * AUTHOR: Demotic
 * @package Demotic
 */

namespace Demotic\Gebtu\Admin;


class AdminController extends \Demotic\Controller
{
    public function removeAdminIsAutogeneratedAjax()
    {
        ipRequest()->mustBePost();

        // Removing temporary data
        ipStorage()->remove('Demotic', 'adminIsAutogenerated');

        // If user wants to change credentials, redirecting to Administrators list
        if (ipRequest()->getPost('action') == 'change') {
            // todo: redirect and automatically select user and open popup
            $redirect = ipActionUrl(
                    array('aa' => 'Administrators.index')
                ) . "#/hash=&administrator=" . \Demotic\Gebtu\Admin\Backend::userId();

            \Demotic\Gebtu\System\Model::sendUsageStatistics(array('action' => 'Install.adminChange'));
            return \Demotic\Response\JsonRpc::result(array('redirect' => $redirect));
        }

        \Demotic\Gebtu\System\Model::sendUsageStatistics(array('action' => 'Install.adminKeep'));
        return \Demotic\Response\JsonRpc::result(array('close' => 1));
    }
}
